% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_endpoints_condition.R
\name{filter_endpoints_condition}
\alias{filter_endpoints_condition}
\alias{filter_endpoints_condition.eventlog}
\alias{filter_endpoints_condition.grouped_log}
\alias{filter_endpoints_condition.activitylog}
\alias{filter_endpoints_conditions}
\title{Filter Start and End Conditions}
\usage{
filter_endpoints_condition(
  log,
  start_condition = NULL,
  end_condition = NULL,
  reverse = FALSE
)

\method{filter_endpoints_condition}{eventlog}(
  log,
  start_condition = NULL,
  end_condition = NULL,
  reverse = FALSE
)

\method{filter_endpoints_condition}{grouped_log}(
  log,
  start_condition = NULL,
  end_condition = NULL,
  reverse = FALSE
)

\method{filter_endpoints_condition}{activitylog}(
  log,
  start_condition = NULL,
  end_condition = NULL,
  reverse = FALSE
)

filter_endpoints_conditions(
  log,
  start_condition = NULL,
  end_condition = NULL,
  reverse = FALSE
)
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{start_condition, end_condition}{A logical condition.}

\item{reverse}{\code{\link{logical}} (default \code{FALSE}): Indicating whether the selection should be reversed.}
}
\value{
When given an object of type \code{\link[bupaR]{log}}, it will return a filtered \code{\link[bupaR]{log}}.
When given an object of type \code{\link[bupaR]{grouped_log}}, the filter will be applied in a stratified way (i.e. each separately for each group).
The returned log will be grouped on the same variables as the original log.
}
\description{
Filters cases where the first and/or last activity adhere to the specified conditions.
}
\section{Methods (by class)}{
\itemize{
\item \code{filter_endpoints_condition(eventlog)}: Filters cases for an \code{\link[bupaR]{eventlog}}.

\item \code{filter_endpoints_condition(grouped_log)}: Filters cases for a \code{\link[bupaR]{grouped_log}}.

\item \code{filter_endpoints_condition(activitylog)}: Filters cases for an \code{\link[bupaR]{activitylog}}.

}}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
Other filters: 
\code{\link{filter_activity}()},
\code{\link{filter_activity_frequency}()},
\code{\link{filter_activity_instance}()},
\code{\link{filter_activity_presence}()},
\code{\link{filter_case}()},
\code{\link{filter_case_condition}()},
\code{\link{filter_endpoints}()},
\code{\link{filter_flow_time}()},
\code{\link{filter_idle_time}()},
\code{\link{filter_infrequent_flows}()},
\code{\link{filter_lifecycle}()},
\code{\link{filter_lifecycle_presence}()},
\code{\link{filter_precedence}()},
\code{\link{filter_precedence_condition}()},
\code{\link{filter_precedence_resource}()},
\code{\link{filter_processing_time}()},
\code{\link{filter_resource}()},
\code{\link{filter_resource_frequency}()},
\code{\link{filter_throughput_time}()},
\code{\link{filter_time_period}()},
\code{\link{filter_trace}()},
\code{\link{filter_trace_frequency}()},
\code{\link{filter_trace_length}()},
\code{\link{filter_trim}()},
\code{\link{filter_trim_lifecycle}()}
}
\concept{filters}
\concept{filters_case}
