% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{eg_read}
\alias{eg_read}
\title{Download a File from Egnyte}
\usage{
eg_read(path, destfile = NULL)
}
\arguments{
\item{path}{The Egnyte path to the file (e.g., "/Shared/Documents/file.txt").}

\item{destfile}{Local file path where the file will be saved. If NULL
(default), the file is downloaded to a temporary file.}
}
\value{
The local file path (invisibly).
}
\description{
Downloads a file from Egnyte cloud storage to a local path.
}
\examples{
\dontrun{
# Download to a specific location
eg_read("/Shared/Documents/report.pdf", "local_report.pdf")

# Download to a temp file
local_path <- eg_read("/Shared/Documents/data.csv")
read.csv(local_path)
}

}
