% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compiler-backends.R
\name{EinopsBackend}
\alias{EinopsBackend}
\title{Base Backend Class for Einops Tensor Operations}
\description{
Abstract base class that defines the interface for tensor operations
across different frameworks. All backend implementations must inherit
from this class and implement the required methods.
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-EinopsBackend-new}{\code{EinopsBackend$new()}}
\item \href{#method-EinopsBackend-print}{\code{EinopsBackend$print()}}
\item \href{#method-EinopsBackend-repr}{\code{EinopsBackend$repr()}}
\item \href{#method-EinopsBackend-tensor_type}{\code{EinopsBackend$tensor_type()}}
\item \href{#method-EinopsBackend-preprocess}{\code{EinopsBackend$preprocess()}}
\item \href{#method-EinopsBackend-create_tensor}{\code{EinopsBackend$create_tensor()}}
\item \href{#method-EinopsBackend-as_array}{\code{EinopsBackend$as_array()}}
\item \href{#method-EinopsBackend-flatten}{\code{EinopsBackend$flatten()}}
\item \href{#method-EinopsBackend-arange}{\code{EinopsBackend$arange()}}
\item \href{#method-EinopsBackend-shape}{\code{EinopsBackend$shape()}}
\item \href{#method-EinopsBackend-reshape}{\code{EinopsBackend$reshape()}}
\item \href{#method-EinopsBackend-transpose}{\code{EinopsBackend$transpose()}}
\item \href{#method-EinopsBackend-reduce}{\code{EinopsBackend$reduce()}}
\item \href{#method-EinopsBackend-stack_on_zeroth_dimension}{\code{EinopsBackend$stack_on_zeroth_dimension()}}
\item \href{#method-EinopsBackend-add_axis}{\code{EinopsBackend$add_axis()}}
\item \href{#method-EinopsBackend-add_axes}{\code{EinopsBackend$add_axes()}}
\item \href{#method-EinopsBackend-tile}{\code{EinopsBackend$tile()}}
\item \href{#method-EinopsBackend-concat}{\code{EinopsBackend$concat()}}
\item \href{#method-EinopsBackend-is_float_type}{\code{EinopsBackend$is_float_type()}}
\item \href{#method-EinopsBackend-layers}{\code{EinopsBackend$layers()}}
\item \href{#method-EinopsBackend-einsum}{\code{EinopsBackend$einsum()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-new"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-new}{}}}
\subsection{Method \code{new()}}{
Initialize the backend and check for required packages.
It is assumed that the constructor will fully load and
setup all dependencies and error otherwise.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new EinopsBackend instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-print"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-print}{}}}
\subsection{Method \code{print()}}{
The print method for EinopsBackend instances
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{arguments passed to \code{\link[=pprint]{pprint()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-repr"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-repr}{}}}
\subsection{Method \code{repr()}}{
Get a string representation of this backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$repr()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character string describing the backend.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-tensor_type"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-tensor_type}{}}}
\subsection{Method \code{tensor_type()}}{
Get the type of tensor this backend supports.
This method should be overridden in subclasses to return the specific
tensor type (e.g., "torch_tensor", "array").
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$tensor_type()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A string representing the tensor type.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-preprocess"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-preprocess}{}}}
\subsection{Method \code{preprocess()}}{
Do any relevant preprocessing of a tensor before any operations are
done on it. This should always be called before running any backend
operations on a tensor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$preprocess(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The input raw tensor-like object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A preprocessed version of the input, may or may not have changed
classes
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-create_tensor"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-create_tensor}{}}}
\subsection{Method \code{create_tensor()}}{
Create a tensor of the specified type with given values and dimensions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$create_tensor(values, dims, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{A vector of values to initialize the tensor.}

\item{\code{dims}}{A numeric vector specifying the dimensions of the tensor.}

\item{\code{...}}{Additional arguments for specific backend implementations.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A tensor of the specified type.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-as_array"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-as_array}{}}}
\subsection{Method \code{as_array()}}{
Convert a tensor to a standard \code{\link[base:array]{base::array()}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$as_array(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The input tensor/array.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A standard array representation of the tensor.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-flatten"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-flatten}{}}}
\subsection{Method \code{flatten()}}{
Return a flattened version of the tensor. Note that the
order of calling as_array and flatten does matter because
different frameworks may store data differently.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$flatten(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The input tensor/array}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A 1 dimensional tensor
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-arange"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-arange}{}}}
\subsection{Method \code{arange()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$arange(start, stop)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{start}}{integer, inclusive}

\item{\code{stop}}{integer, inclusive}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a sequence from start to stop
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-shape"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-shape}{}}}
\subsection{Method \code{shape()}}{
Get the shape of a tensor.
Shape should return a tuple with integers or "shape symbols"
(which will evaluate to actual size).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$shape(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The input tensor/array.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric vector representing the tensor shape.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-reshape"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-reshape}{}}}
\subsection{Method \code{reshape()}}{
Reshape a tensor to the specified dimensions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$reshape(x, shape)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The input tensor/array.}

\item{\code{shape}}{A numeric vector specifying the new shape.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The reshaped tensor/array.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-transpose"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-transpose}{}}}
\subsection{Method \code{transpose()}}{
Transpose a tensor along the specified axes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$transpose(x, axes)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The input tensor/array.}

\item{\code{axes}}{A numeric vector specifying the new axis order.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transposed tensor/array.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-reduce"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-reduce}{}}}
\subsection{Method \code{reduce()}}{
Reduce a tensor along specified axes using the given operation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$reduce(x, operation, axes)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The input tensor/array.}

\item{\code{operation}}{A character string specifying the reduction operation
(e.g., "sum", "mean", "max", "min", "prod", "all", "any"), OR
a two argument function, with the first argument being the tensor
to modify, and the second argument being an integer list of axes
to perform the reduction over.}

\item{\code{axes}}{A numeric vector specifying which axes to reduce over.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The reduced tensor/array.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-stack_on_zeroth_dimension"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-stack_on_zeroth_dimension}{}}}
\subsection{Method \code{stack_on_zeroth_dimension()}}{
Stack multiple tensors along a new zeroth dimension.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$stack_on_zeroth_dimension(tensors)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tensors}}{A list of tensors/arrays to stack.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A tensor/array with the input tensors stacked along dimension 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-add_axis"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-add_axis}{}}}
\subsection{Method \code{add_axis()}}{
Add a new axis to a tensor at the specified position.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$add_axis(x, new_position)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The input tensor/array.}

\item{\code{new_position}}{The position (1-based) where to insert the new axis.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The tensor/array with a new axis added.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-add_axes"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-add_axes}{}}}
\subsection{Method \code{add_axes()}}{
Add multiple axes to a tensor and tile along specified axes.

This function adds new axes to the input tensor at the specified
positions and tiles the tensor along those axes according to the
provided lengths.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$add_axes(x, n_axes, pos2len)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The input tensor/array.}

\item{\code{n_axes}}{The total number of axes after addition.}

\item{\code{pos2len}}{int->int \code{\link[r2r:hashtable]{r2r::hashmap()}} mapping positions to lengths.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The tensor/array with new axes added and tiled as specified.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-tile"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-tile}{}}}
\subsection{Method \code{tile()}}{
Tile (repeat) a tensor along each axis according to the repeat counts.
The repeats vector should have the same length as the tensor's shape.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$tile(x, repeats)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The input tensor/array.}

\item{\code{repeats}}{A numeric vector specifying how many times to repeat
along each axis. Must have same length as x.shape.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The tiled tensor/array.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-concat"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-concat}{}}}
\subsection{Method \code{concat()}}{
Concatenate tensors along the specified axis.
Assumes identical devices, dtypes and shapes except for the selected axis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$concat(tensors, axis)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tensors}}{A list of tensors/arrays to concatenate.}

\item{\code{axis}}{The axis along which to concatenate (1-based).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The concatenated tensor/array.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-is_float_type"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-is_float_type}{}}}
\subsection{Method \code{is_float_type()}}{
Check if the tensor has a floating point data type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$is_float_type(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The input tensor/array.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A logical value indicating if the tensor is of float type.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-layers"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-layers}{}}}
\subsection{Method \code{layers()}}{
Get neural network layers specific to this backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$layers()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Backend-specific layer implementations.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EinopsBackend-einsum"></a>}}
\if{latex}{\out{\hypertarget{method-EinopsBackend-einsum}{}}}
\subsection{Method \code{einsum()}}{
Perform Einstein summation on tensors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EinopsBackend$einsum(pattern, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pattern}}{A character string specifying the einsum pattern.}

\item{\code{...}}{Additional tensors to operate on.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The result of the einsum operation.
}
}
}
