% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.R
\name{expr_list}
\alias{expr_list}
\alias{[.expr_list}
\alias{[<-.expr_list}
\title{Make a list of expressions}
\usage{
expr_list(..., env = parent.frame())

\method{[}{expr_list}(xl, i)

\method{[}{expr_list}(xl, i) <- value
}
\arguments{
\item{...}{\link[=elixir-expression]{Expressions} to include in the list. If the
arguments are named, these will be passed on to the returned list.}

\item{env}{Environment for injections in \code{...} (see
\link[=elixir-expression]{expression}).}

\item{xl}{An \code{expr_list}.}

\item{i}{Index for subsetting the \code{expr_list}; an integer, numeric, logical,
or character vector (for named \code{expr_list}s) interpreted in the usual R way.}

\item{value}{Replacement; an \code{expr_list}, an expression, or a list of
expressions.}
}
\value{
A list of expressions, of class \code{expr_list}.
}
\description{
Constructs a list of expressions, with support for \code{elixir}'s special
\link[=elixir-expression]{expression} syntax (expression literals with \code{{}} or
\code{~{}}, and alternatives with \verb{?}).
}
\details{
Be aware that using the \code{[[} indexing operator on an object of class
\code{expr_list} discards information about whether that element of the list is
marked as anchored. In other words, if \code{xl <- expr_list({.A}, ~{.A})},
then \code{xl[[1]]} and \code{xl[[2]]} are both equal to the "bare" symbol \code{.A}, so
the information that the second element of the list is anchored has been
lost. Consequently, in e.g. \code{expr_match(expr, xl[[2]])}, it will be as
though the tilde isn't there, and \code{xl[[2]]} will not just match with the top
level of \code{expr} as was probably intended. Use the \code{[} operator instead,
which retains anchoring information; \code{expr_match(expr, xl[2])} will work as
expected.

Note that when you replace part of an \code{expr_list} with another \code{expr_list},
the anchoring information from the "replacement" \code{expr_list} is copied over,
while replacing part of an \code{expr_list} with an expression or a "plain" list
of expressions retains the existing anchoring information.
}
\examples{
expr_list(
   ~{ 1 + 1 = 2 } ? ~{ 2 + 2 = 4 },
   ~{ y = a * x + b },
   { .A }
)

# There is support for rlang's injection operators.
var = as.name("myvar")
expr_list({ 1 }, { !!var }, { (!!var)^2 })
}
