% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{elm_predict}
\alias{elm_predict}
\title{Extreme Learning Machine predict function}
\usage{
elm_predict(elm_train_object, newdata, normalize = FALSE)
}
\arguments{
\item{elm_train_object}{it should be the output of the \emph{elm_train} function}

\item{newdata}{an input matrix with number of columns equal to the \emph{x} parameter of the \emph{elm_train} function}

\item{normalize}{a boolean specifying if the output predictions \emph{in case of classification} should be normalized. If TRUE then the values of each row of the output-probability-matrix that are less than 0 and greater than 1 will be pushed to the [0,1] range}
}
\description{
Extreme Learning Machine predict function
}
\examples{

library(elmNNRcpp)

#-----------
# Regression
#-----------

data(Boston, package = 'KernelKnn')

Boston = as.matrix(Boston)
dimnames(Boston) = NULL

x = Boston[, -ncol(Boston)]
y = matrix(Boston[, ncol(Boston)], nrow = length(Boston[, ncol(Boston)]), ncol = 1)

out_regr = elm_train(x, y, nhid = 20, actfun = 'purelin', init_weights = 'uniform_negative')

pr_regr = elm_predict(out_regr, x)


#---------------
# Classification
#---------------

data(ionosphere, package = 'KernelKnn')

x_class = ionosphere[, -c(2, ncol(ionosphere))]
x_class = as.matrix(x_class)
dimnames(x_class) = NULL

y_class = as.numeric(ionosphere[, ncol(ionosphere)])

y_class_onehot = onehot_encode(y_class - 1)     # class labels should begin from 0

out_class = elm_train(x_class, y_class_onehot, nhid = 20, actfun = 'relu')

pr_class = elm_predict(out_class, x_class, normalize = TRUE)

}
