% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lead_data_loaders.R
\name{load_census_tract_data}
\alias{load_census_tract_data}
\title{Load Census Tract Data}
\usage{
load_census_tract_data(states = NULL, verbose = TRUE)
}
\arguments{
\item{states}{Character vector of state abbreviations to filter by (optional)}

\item{verbose}{Logical, print status messages (default TRUE)}
}
\value{
A tibble with columns:
\itemize{
\item geoid: Census tract identifier
\item state_abbr: State abbreviation
\item county_name: County name
\item tract_name: Tract name
\item utility_name: Electric utility serving this tract
\item Additional demographic columns
}
}
\description{
Load census tract demographics and utility service territory information
with automatic fallback to CSV or OpenEI download.
}
\examples{
\donttest{
if (interactive()) {
  # Single state (requires census data download)
  nc_tracts <- load_census_tract_data(states = "NC")

  # Multiple states (regional)
  southeast <- load_census_tract_data(states = c("NC", "SC", "GA", "FL"))

  # Nationwide (all ~73,000 census tracts)
  us_tracts <- load_census_tract_data()  # No filter = all states
}
}
}
