\name{DT_fulldiallel}
\alias{DT_fulldiallel}
\docType{data}
\title{
Full diallel data for corn hybrids
}
\description{
This dataset contains phenotpic data for 36 winter bean hybrids, coming from a full diallel design and evaluated for 9 traits. The column male and female origin columns are included as well. 

}
\usage{data("DT_fulldiallel")}
\format{
  The format is:
 chr "DT_fulldiallel"
}
\source{
This data was generated by a winter bean study and originally included in the agridat package.
}
\references{

Covarrubias-Pazaran G (2016) Genome assisted prediction of quantitative traits using the R package sommer. PLoS ONE 11(6): doi:10.1371/journal.pone.0156744 

Giovanny Covarrubias-Pazaran (2024).  lme4breeding: enabling genetic evaluation in the age of genomic data. To be submitted to Bioinformatics.

Douglas Bates, Martin Maechler, Ben Bolker, Steve Walker (2015). Fitting Linear Mixed-Effects Models Using lme4. Journal of Statistical Software, 67(1), 1-48.

}
\examples{

data(DT_fulldiallel)
DT <- DT_fulldiallel
head(DT)

\donttest{

############## sommer ################

if(requireNamespace("sommer")){
library(sommer)
mix <- mmes(stems~1, random=~female+male, data=DT)
summary(mix)

}

############## lme4breeding ################

if(requireNamespace("lme4breeding")){
library(lme4breeding)
mix <- lmeb(stems~1 + (1|female)+(1|male),
                data=DT)
vc <- VarCorr(mix); print(vc,comp=c("Variance"))
sigma(mix)^2 # error variance
BLUP <- ranef(mix, condVar=TRUE)
condVAR <- lapply(BLUP, function(x){attr(x, which="postVar")}) # take sqrt() for SEs

}

}


}
\keyword{datasets}
