\name{DT_h2}
\alias{DT_h2}
\docType{data}
\title{
Broad sense heritability calculation.
}
\description{
This dataset contains phenotpic data for 41 potato lines evaluated in 5 locations across 3 years in an RCBD design. The phenotypic trait is tuber quality and we show how to obtain an estimate of DT_h2 for the trait.

}
\usage{data("DT_h2")}
\format{
  The format is:
 chr "DT_h2"
}
\source{
This data was generated by a potato study.
}
\references{

Covarrubias-Pazaran G (2016) Genome assisted prediction of quantitative traits using the R package sommer. PLoS ONE 11(6): doi:10.1371/journal.pone.0156744 

Giovanny Covarrubias-Pazaran (2024).  lme4breeding: enabling genetic evaluation in the age of genomic data. To be submitted to Bioinformatics.

Douglas Bates, Martin Maechler, Ben Bolker, Steve Walker (2015). Fitting Linear Mixed-Effects Models Using lme4. Journal of Statistical Software, 67(1), 1-48.

}
\examples{

data(DT_h2)
DT <- DT_h2
head(DT)

\donttest{

############### sommer ################
if(requireNamespace("sommer")){
library(sommer)
DT=DT[with(DT, order(Env)), ]
ans1 <- mmes(y~Env, henderson=TRUE,
              random=~vsm(dsm(Env),ism(Name)) + vsm(dsm(Env),ism(Block)),
              rcov=~vsm(dsm(Env),ism(units)),
              data=DT)
summary(ans1)$varcomp

}

############### lme4breeding ################
if(requireNamespace("lme4breeding")){
library(lme4breeding)
# model with:
# Main+Diagonal for Name
# Diagonal for Block
# Diagonal for residuals
DT=DT[with(DT, order(Env)), ]
ans1b <- lmeb(y ~ Env + (Env||Name) + (0+Env||Block) + (0+Env||unitsR),
                  verbose = 1L,
                  data=DT)
vc <- VarCorr(ans1b); print(vc,comp=c("Variance"))
sigma(ans1b)^2 # error variance

BLUP <- ranef(ans1b, condVar=TRUE)
condVAR <- lapply(BLUP, function(x){attr(x, which="postVar")}) # take sqrt() for SEs

}
############### end ################

}


}
\keyword{datasets}
