% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toFigure.R
\name{tofigure}
\alias{tofigure}
\title{output figures to different formats}
\usage{
tofigure(figure, format = NULL, filename = "temp.pdf")
}
\arguments{
\item{figure}{output figure function, set NULL output the current figure}

\item{format}{output format (could be ingored)}

\item{filename}{output filename with different format as suffix}
}
\description{
output figures to different formats
}
\examples{
require(ggplot2)
p <- ggplot(mtcars, aes(mpg, disp, color = factor(cyl))) + geom_point()
tofigure(p,filename = file.path(tempdir(), "mtcars.pdf"))
## or use ggplot directly
tofigure(ggplot(mtcars, aes(mpg, disp, color = factor(cyl))) +
geom_point(), filename = file.path(tempdir(), "mtcars.eps"))
\donttest{
## if you use basic plot function or other plot function you
## need first use convertplot to convert it to ggplot object
## when you are working on the platform without GUI
p <- convertplot(plot(1:10))
tofigure(p, filename = file.path(tempdir(), "mtcars.pdf"))
topptx(p, filename = file.path(tempdir(), "mtcars.pptx"))
}
}
\author{
Kai Guo
}
