% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prevent.R
\name{prevent}
\alias{prevent}
\title{Explore effect of prevention}
\usage{
prevent(scc, causes = NULL, output = c("nice", "table"))
}
\arguments{
\item{scc}{An object of class \code{epicmodel_scc}.}

\item{causes}{A character vector containing step IDs of component causes. If NULL (default), prints a list of all available component causes in
the console.}

\item{output}{Either "nice" (default) or "table". If "nice", prints a nicely formatted summary in the console. If "table", returns a data.frame
(described in section "Value" below).}
}
\value{
If \code{output = "nice"} (default), prints a nicely formatted output in the console. If \code{output = "table"}, returns a data.frame with one
row for every prevention set and one column for every component cause provided in argument \code{causes}. All cells are either TRUE or FALSE with TRUE
indicating that the corresponding variable needs to be prevented in the corresponding set, and FALSE indicating that prevention in the corresponding
set is not necessary.
}
\description{
Prevention refers to the avoidance of component causes, i.e., of elements of sufficient causes. For a given set of component causes, \code{prevent()}
derives, which of them need to be "removed" in order to avoid outcome occurrence. Reported are the smallest prevention sets, i.e., with the
fewest component causes.
}
\details{
The following algorithm is used to evaluate the effect of prevention:
\itemize{
\item Evaluate if \code{causes} is sufficient for outcome occurrence. If not, report so and stop.
\item Derive a list of all combinations of the component causes provided in \code{causes}. The set "all causes present" is not evaluated as it is
already known to be sufficient. In addition, the set "all causes absent", i.e., "all causes prevented" is considered.
\item Evaluate sufficiency for every set
\item Subset the list of cause sets to the ones, which are \code{not} sufficient, because for them prevention was successful.
\item Turn all FALSE to TRUE and all TRUE to FALSE. Now, FALSE indicates present and TRUE indicates absent, i.e., prevented.
\item Evaluate, which prevention sets are minimal, i.e., the smallest set to prevent the outcome.
}
}
\examples{
# Derive SCC model
scc_model <- scc_rain

# Derive prevention sets
prevent(scc_model, causes = c("IFNOTd6a6THENd5a6","THENa5","THENa1","THENd2a3"))
}
