% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence_plot.R
\name{convergence_plot}
\alias{convergence_plot}
\title{Plot the convergence processes from a collection of simulations.}
\usage{
convergence_plot(x, ...)
}
\arguments{
\item{x}{object of type \code{\link{simulations_collection}}}

\item{...}{extra args are passed onwards to stack_sims_vert}
}
\value{
a ggplot2 plot
}
\description{
Plot the convergence processes from a collection of simulations.
}
\examples{
design1 <- get_mtpi2(
  num_doses = 5, target = 0.25,
  epsilon1 = 0.05, epsilon2 = 0.05,
  exclusion_certainty = 0.95
) \%>\%
  stop_at_n(n = 12)
design2 <- get_mtpi2(
  num_doses = 5, target = 0.25,
  epsilon1 = 0.1, epsilon2 = 0.1,
  exclusion_certainty = 0.95
) \%>\%
  stop_at_n(n = 12)
designs <- list(
  "Design1" = design1,
  "Design2" = design2
)
sims <- simulate_compare(
  designs = designs,
  num_sims = 20,
  true_prob_tox = c(0.1, 0.2, 0.3, 0.4, 0.5)
)
convergence_plot(sims)
}
