% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wages_tait_selector.R
\name{get_wages_and_tait}
\alias{get_wages_and_tait}
\title{Get an object to fit Wages & Tait's model for phase I/II dose-finding.}
\usage{
get_wages_and_tait(
  parent_selector_factory = NULL,
  tox_skeleton,
  eff_skeletons,
  eff_skeleton_weights = rep(1, nrow(eff_skeletons)),
  tox_limit,
  eff_limit,
  num_randomise,
  ...
)
}
\arguments{
\item{parent_selector_factory}{optional object of type
\code{\link{selector_factory}} that is in charge of dose selection before
this class gets involved. Leave NULL to just use this model from the start.}

\item{tox_skeleton}{Dose-toxicity skeleton, a non-decreasing vector of
probabilities.}

\item{eff_skeletons}{Matrix of dose-efficacy skeletons, with the skeletons in
rows. I.e. number of cols is equal to number of doses, and number of rows is
equal to number of efficacy skeletons under consideration.}

\item{eff_skeleton_weights}{numerical vector, prior weights to efficacy
skeletons. Should have length equal to number of rows in
\code{eff_skeletons}. Default is equal weights.}

\item{tox_limit}{We seek a dose with probability of toxicity no greater than
this. Value determines the admissible set. See Wages & Tait (2015).}

\item{eff_limit}{We seek a dose with probability of efficacy no less than
this.}

\item{num_randomise}{integer, maximum number of patients to use in the
adaptive randomisation phase of the trial.}

\item{...}{Extra args are passed onwards.}
}
\value{
an object of type \code{\link{selector_factory}}.
}
\description{
This function returns an object that can be used to fit Wages & Taits model
for phase I/II dose-finding, i.e. it selects doses according to efficacy and
toxicity outcomes. This function delegates prior-to-posterior calculations to
the dfcrm package.
}
\examples{
# Example in Wages & Tait (2015)
tox_skeleton = c(0.01, 0.08, 0.15, 0.22, 0.29, 0.36)
eff_skeletons = matrix(nrow=11, ncol=6)
eff_skeletons[1,] <- c(0.60, 0.50, 0.40, 0.30, 0.20, 0.10)
eff_skeletons[2,] <- c(0.50, 0.60, 0.50, 0.40, 0.30, 0.20)
eff_skeletons[3,] <- c(0.40, 0.50, 0.60, 0.50, 0.40, 0.30)
eff_skeletons[4,] <- c(0.30, 0.40, 0.50, 0.60, 0.50, 0.40)
eff_skeletons[5,] <- c(0.20, 0.30, 0.40, 0.50, 0.60, 0.50)
eff_skeletons[6,] <- c(0.10, 0.20, 0.30, 0.40, 0.50, 0.60)
eff_skeletons[7,] <- c(0.20, 0.30, 0.40, 0.50, 0.60, 0.60)
eff_skeletons[8,] <- c(0.30, 0.40, 0.50, 0.60, 0.60, 0.60)
eff_skeletons[9,] <- c(0.40, 0.50, 0.60, 0.60, 0.60, 0.60)
eff_skeletons[10,] <- c(0.50, 0.60, 0.60, 0.60, 0.60, 0.60)
eff_skeletons[11,] <- c(rep(0.60, 6))
eff_skeleton_weights = rep(1, nrow(eff_skeletons))
tox_limit = 0.33
eff_limit = 0.05
model <- get_wages_and_tait(tox_skeleton = tox_skeleton,
                            eff_skeletons = eff_skeletons,
                            tox_limit = tox_limit, eff_limit = eff_limit,
                            num_randomise = 20)
fit <- model \%>\% fit('1NN 2EN 3BE')
fit \%>\% recommended_dose()
fit \%>\% is_randomising()
fit \%>\% dose_admissible()
fit \%>\% prob_administer()

}
\references{
Wages, N. A., & Tait, C. (2015).
Seamless Phase I/II Adaptive Design for Oncology Trials of Molecularly
Targeted Agents.
Journal of Biopharmaceutical Statistics, 25(5), 903–920.
https://doi.org/10.1080/10543406.2014.920873
}
