% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_palette.R
\name{get_palette}
\alias{get_palette}
\title{Get Palette: Load Color Palette from RDS}
\usage{
get_palette(
  name,
  type = c("sequential", "diverging", "qualitative"),
  n = NULL,
  palette_rds = system.file("extdata", "palettes.rds", package = "evanverse")
)
}
\arguments{
\item{name}{Character. Name of the palette (e.g. "qual_vivid").}

\item{type}{Character. One of "sequential", "diverging", "qualitative".}

\item{n}{Integer. Number of colors to return. If NULL, returns all colors. Default is NULL.}

\item{palette_rds}{Character. Path to RDS file. Default uses system file in package.}
}
\value{
Character vector of HEX color codes.
}
\description{
Load a named palette from data/palettes.rds, returning a vector of HEX colors.
Automatically checks for type mismatch and provides smart suggestions.
}
\examples{
get_palette("qual_vivid", type = "qualitative")
get_palette("qual_softtrio", type = "qualitative", n = 2)
get_palette("seq_blues", type = "sequential", n = 3)
get_palette("div_contrast", type = "diverging")

}
