% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abm-ga.R
\name{abm.ga}
\alias{abm.ga}
\title{Genetic Algorithm metaheuristic}
\usage{
abm.ga(objective, options = NULL)
}
\arguments{
\item{objective}{An instance of ObjectiveFunction (or subclass) class \link{ObjectiveFunction}}

\item{options}{An apropiate instance from a sublclass of \link{Options} class}
}
\description{
An implementation of Genetic Algorithm metaheuristic for parameter estimation
}
\examples{
\dontrun{
 f<- PlainFunction$new(f0.rosenbrock2)

 f$Parameter(name="x1",min=-100,max=100)
 f$Parameter(name="x2",min=-100,max=100)

 or

 f$Parameter0(name="x1",levels=c(0:4))
 f$Parameter0(name="x2",levels=c(-2,-1,0,1,2))

 extremize("tabu", f)
}

}
\references{
[1] John Henry Holland (1992). "Adaptation in Natural and Artificial Systems; An Introductory Analysis
with Applications to Biology, Control and Artificial Intelligence". MIT Press, Cambridge, MA, USA.
ISBN 0262082136.
[2] Zbigniew Michalewiczx (1994). "Genetic Algorithms + Data Structures = Evolution Programs (2nd Ed.)".
Springer-Verlag, Berlin, Heidelberg. ISBN 3540580905.
}
