% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_matrix_sk.R
\name{html_matrix_sk}
\alias{html_matrix_sk}
\alias{lmatrix}
\title{\code{html_matrix} Object Creation}
\usage{
html_matrix_sk(
  m,
  title,
  fmt,
  byrow = TRUE,
  tooltip = "Die Tabelle hat \%.0f Zeilen und \%.0f Spalten",
  ...
)

lmatrix(
  m,
  title,
  fmt,
  byrow = TRUE,
  tooltip = "Die Tabelle hat \%.0f Zeilen und \%.0f Spalten",
  ...
)
}
\arguments{
\item{m}{vector, matrix, array, table or html_matrix: input}

\item{title}{character: text for the upper left entry}

\item{fmt}{character: text format for rows (or columns)}

\item{byrow}{logical: \code{fmt} by row or by column (default: \code{TRUE})}

\item{tooltip}{character: text for tooltip with column and row numbers (default: \code{"Die Tabelle hat \%.0f Zeilen und \%.0f Spalten"})}

\item{...}{further parameters given to \code{html_matrix}}
}
\value{
An \code{html_matrix} object.
}
\description{
My personal pipe creating an \code{html_matrix} object. Note that the length of \code{fmt}
must be either \code{nrow(m)} or \code{ncol(m)} depending on \code{byrow}.

\preformatted{
   html_matrix(m) %>% hm_title(title) %>% zebra() %>%
     tooltip(sprintf(tooltip, nrow(m), ncol(m))) %>%
     hm_cell(fmt=fmt, byrow=byrow)
}
}
\examples{
m <- matrix(1:6, ncol=2)
html_matrix_sk(m, title="", fmt=c("\%.0f", "\%.1f"))
}
