% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pprobability.R
\name{pprobability}
\alias{pprobability}
\alias{polynomial_probability}
\title{Polynomial Probability}
\usage{
pprobability(
  x,
  power = 1,
  zero = FALSE,
  coef = round(seq(-1, 1, by = 0.1), 1),
  sample = rep(1, length(x)),
  pl = NULL,
  tol = 1e-09
)

polynomial_probability(
  x,
  power = 1,
  zero = FALSE,
  coef = round(seq(-1, 1, by = 0.1), 1),
  sample = rep(1, length(x)),
  pl = NULL,
  tol = 1e-09
)
}
\arguments{
\item{x}{numeric: values of a discrete random variable}

\item{power}{integer: the degree for the polynomials (default: \code{1}), must be larger 0}

\item{zero}{logical: are zero coefficients and zero samples allowed? (default: \code{FALSE})}

\item{coef}{matrix: for each degree coefficients to sample from (default: \code{seq(-1, 1, by=0.1)})}

\item{sample}{integer: number of \eqn{x} values in the sample or sample size (default: \code{rep(1, length(x))})}

\item{pl}{polylist: a list of polynomials which describes the probability for \eqn{x} (default: \code{NULL})}

\item{tol}{numeric: tolerance to detect zero values (default: \code{1e-9})}
}
\value{
A list with the components:
\itemize{
\item \code{p}: the polynomials for the probabilities
\item \code{ep}: the expected value as polynomial
\item \code{x}: the values for the discrete random variable, the same as the input \code{x}
\item \code{sample}: the sample given or generated
\item \code{LS$pi}: the summands for the least squares problem
\item \code{LS$pl}: the summands for the least squares problem in LaTeX
\item \code{LS$pf}: the sum of \code{LS$pi}
\item \code{LS$df}: the derivative of \code{LS$pf}
\item \code{LS$pest}: the estimated parameter, minimum of \code{LS$pf}
\item \code{LS$p}: the estimated probabilities
\item \code{ML$pi}: the factors for the maximum likelihood problem
\item \code{ML$pl}: the summands for the maximum likelihood problem in LaTeX
\item \code{ML$pf}: the product of \code{ML$pi}
\item \code{ML$df}: the derivative of \code{ML$pf}
\item \code{ML$pest}: the estimated parameter, maximum of \code{ML$pf}
\item \code{ML$p}: the estimated probabilities
}
}
\description{
Creates for each value of a discrete random variable, a polynomial and estimates the least squares and the maximum likelihood solution.
The following conditions stand:
\itemize{
\item If \code{sample} is not given then the sample contains each \code{x} value once.
\item If \code{sample} is an integer, then it is interpreted as the sample size and a sample is generated by \code{rmultinom(1, sample, ddiscrete(runif(length(x))))}.
\item If \code{sample} is a vector, it is interpreted in such a way that the corresponding \code{x[i]} value occurs \code{i} times in the sample. Thus, \code{sum(sample)} is the sample size.
\item If \code{coeff} is a \code{polylist} of \code{length(x)}, then these polynomials are taken.
\item If \code{coeff} is a \code{matrix} with \code{length(x)}, columns and \code{power+1} rows, then the columns are interpreted as the coefficients of a polynomial.
\item Otherwise \code{coeff} is interpreted as a vector from which the coefficient is sampled. The intercepts are sampled via \code{ddiscrete(runif(length(x)), zero=zero)}.
If \code{coeff} is not given then it is ensured that the least squares and the maximum likelihood solution exists and the estimated probabilities are between zero and one.
Otherwise, the results may contain \code{NA} or the estimated probabilities are outside the interval \eqn{[0;1]}.
}
}
\examples{
# linear polynomials
pprobability(0:2)
pprobability(0:2, power=1)
# constant polynomials, some NAs are generated
pprobability(0:3, power=0)
# polynomials generated from a different set
pprobability(0:2, coef=seq(-2, 2, by=0.1))
pprobability(0:2, 0, coef=seq(-2, 2, by=0.1))
# polynomials (x, x, 1-2*x) are used
pprobability(0:2, 0, coef=matrix(c(0.4, 0.4, 0.3), ncol=3))
pprobability(0:2, 1, coef=polylist(c(0,1), c(0,1), c(1, -2)))
}
