% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique_max.R
\name{unique_max}
\alias{unique_max}
\title{Unique Maximum}
\usage{
unique_max(x, tol = 0.001)
}
\arguments{
\item{x}{numeric: values to check}

\item{tol}{numeric: minimum distance between the largest and the second largest value (default: \code{1e-3})}
}
\value{
Logical
}
\description{
Checks if \code{x} has a unique maximum. The largest and the second largest value must have at least a distance of \code{tol}.
}
\examples{
x <-runif(100)
unique_max(x)
unique_max(x, tol=0.1)
}
