% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exal.R
\name{pexal}
\alias{pexal}
\title{Cumulative Distribution Function (CDF) for the exAL Distribution}
\usage{
pexal(
  q,
  p0 = 0.5,
  mu = 0,
  sigma = 1,
  gamma = 0,
  lower.tail = TRUE,
  log.p = FALSE
)
}
\arguments{
\item{q}{Numeric vector of quantiles.}

\item{p0}{Probability level used in the quantile parametrization. Scalar in (0, 1). Default \code{0.5}.}

\item{mu}{Location parameter (scalar). Default \code{0}.}

\item{sigma}{Scale parameter (scalar, strictly positive). Default \code{1}.}

\item{gamma}{Skewness parameter controlling asymmetry (scalar). Must be within valid bounds implied by \code{p0}. Default \code{0}.}

\item{lower.tail}{Logical scalar; if \code{TRUE} (default) return \eqn{P(X \le q)}, otherwise \eqn{P(X > q)}.}

\item{log.p}{Logical scalar; if \code{TRUE}, return log-probabilities.}
}
\value{
Numeric vector of CDF values (same length as \code{q}).
}
\description{
Vectorized over \code{q}.
}
\examples{
pexal(0)
pexal(c(-1, 0, 1), p0 = 0.5, mu = 0, sigma = 1, gamma = 0.1)

}
