% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.stacked_metrics}
\alias{print.stacked_metrics}
\title{Print stacked metrics}
\usage{
\method{print}{stacked_metrics}(x, ...)
}
\arguments{
\item{x}{\code{stacked_metrics} object}

\item{...}{other print parameters}
}
\description{
Stack metrics sums parity loss metrics for all models. Higher value of stacked metrics means the model is less fair (has higher bias)
for subgroups from protected vector.
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) - 1

lm_model <- glm(Risk ~ .,
  data = german,
  family = binomial(link = "logit")
)

rf_model <- ranger::ranger(Risk ~ .,
  data = german,
  probability = TRUE,
  num.trees = 200,
  num.threads = 1
)

explainer_lm <- DALEX::explain(lm_model, data = german[, -1], y = y_numeric)
explainer_rf <- DALEX::explain(rf_model, data = german[, -1], y = y_numeric)

fobject <- fairness_check(explainer_lm, explainer_rf,
  protected = german$Sex,
  privileged = "male"
)

sm <- stack_metrics(fobject)
print(sm)
}
