% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected-degrees.R
\name{expected_edges}
\alias{expected_edges}
\alias{expected_degrees}
\alias{expected_degree}
\alias{expected_in_degree}
\alias{expected_out_degree}
\alias{expected_density}
\title{Calculate the expected edges in Poisson RDPG graph}
\usage{
expected_edges(factor_model, ...)

expected_degrees(factor_model, ...)

expected_degree(factor_model, ...)

expected_in_degree(factor_model, ...)

expected_out_degree(factor_model, ...)

expected_density(factor_model, ...)
}
\arguments{
\item{factor_model}{A \code{\link[=directed_factor_model]{directed_factor_model()}} or
\code{\link[=undirected_factor_model]{undirected_factor_model()}}.}

\item{...}{Ignored. Do not use.}
}
\value{
Expected edge counts, or graph densities.
}
\description{
These calculations are conditional on the latent factors
\code{X} and \code{Y}.
}
\details{
Note that the runtime of the \code{fastRG} algorithm is proportional to
the expected number of edges in the graph. Expected edge count will be
an underestimate of expected number of edges for Bernoulli
graphs. See the Rohe et al for details.
}
\examples{

##### an undirected blockmodel example

n <- 100
pop <- n / 2
a <- .1
b <- .05

B <- matrix(c(a, b, b, a), nrow = 2)

b_model <- sbm(n = n, B = B, poisson_edges = FALSE)

b_model

A <- sample_sparse(b_model)

# compare
mean(rowSums(triu(A)))

pop * a + pop * b # analytical average degree

##### more generic examples

n <- 1000
k <- 5

X <- matrix(rpois(n = n * k, 1), nrow = n)
S <- matrix(runif(n = k * k, 0, .1), nrow = k)

ufm <- undirected_factor_model(X, S)

expected_edges(ufm)
expected_degree(ufm)
eigs_sym(ufm)

n <- 1000
d <- 100

k1 <- 5
k2 <- 3

X <- matrix(rpois(n = n * k1, 1), nrow = n)
Y <- matrix(rpois(n = d * k2, 1), nrow = d)
S <- matrix(runif(n = k1 * k2, 0, .1), nrow = k1)

dfm <- directed_factor_model(X = X, S = S, Y = Y)

expected_edges(dfm)
expected_in_degree(dfm)
expected_out_degree(dfm)

svds(dfm)

}
\references{
Rohe, Karl, Jun Tao, Xintian Han, and Norbert Binkiewicz. 2017.
"A Note on Quickly Sampling a Sparse Matrix with Low Rank Expectation."
Journal of Machine Learning Research; 19(77):1-13, 2018.
\url{https://www.jmlr.org/papers/v19/17-128.html}
}
