% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_arithmetic.r
\name{Arith,GRaster,logical-method}
\alias{Arith,GRaster,logical-method}
\alias{Arith}
\alias{Arith,logical,GRaster-method}
\alias{Arith,GRaster,numeric-method}
\alias{Arith,GRaster,integer-method}
\alias{Arith,numeric,GRaster-method}
\alias{Arith,integer,GRaster-method}
\alias{Arith,GRaster,GRaster-method}
\alias{Arith,GVector,GVector-method}
\title{Arithmetic operations on GRasters}
\usage{
\S4method{Arith}{GRaster,logical}(e1, e2)

\S4method{Arith}{logical,GRaster}(e1, e2)

\S4method{Arith}{GRaster,numeric}(e1, e2)

\S4method{Arith}{GRaster,integer}(e1, e2)

\S4method{Arith}{numeric,GRaster}(e1, e2)

\S4method{Arith}{integer,GRaster}(e1, e2)

\S4method{Arith}{GRaster,GRaster}(e1, e2)

\S4method{Arith}{GVector,GVector}(e1, e2)
}
\arguments{
\item{e1, e2}{\code{GRaster}s, \code{GVector}s, \code{numeric}s, \code{integer}s, or \code{logical}s.}
}
\value{
A \code{GRaster}.
}
\description{
\strong{\code{GRaster}s}: You can do arithmetic operations on \code{GRaster}s and using normal operators in \strong{R}: \code{+}, \code{-}, \code{*}, \code{/}, \code{^}, \code{\%\%} (modulus), and \code{\%/\%} (integer division).

\strong{\code{GVector}s}: You can also do arithmetic operations on \code{GVector}s:\cr\cr
\code{+} operator: Same as \code{\link[=union]{union()}}\cr
\code{-} operator: Same as \code{\link[=erase]{erase()}}\cr
\code{*} operator: Same as \code{\link[=intersect]{intersect()}}\cr
\code{/} operator: Same as \code{\link[=xor]{xor()}}\cr
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Example data
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster
elev <- fast(madElev)
elevs <- c(elev, elev, log10(elev) - 1, sqrt(elev))
names(elevs) <- c("elev1", "elev2", "log_elev", "sqrt_elev")

elev
elevs

# do some math
elev + 100
elev - 100
elev * 100
elev / 100
elev ^ 2
elev \%/\% 100 # divide then round down
elev \%\% 100 # modulus

100 + elev
100 \%/\% elev
100 \%\% elev

elevs + 100
100 + elevs

# math with logicals
elev + TRUE
elev - TRUE
elev * TRUE
elev / TRUE
elev ^ TRUE
elev \%/\% TRUE # divide then round down
elev \%\% TRUE # modulus

elevs + TRUE
TRUE + elevs

# Raster interacting with raster(s):
elev + elev
elev - elev
elev * elev
elev / elev
elev ^ log(elev)
elev \%/\% sqrt(elev) # divide then round down
elev \%\% sqrt(elev) # modulus

elevs + elev
elev * elevs

# sign
abs(-1 * elev)
abs(elevs)

# powers
sqrt(elevs)

# trigonometry
sin(elev)
cos(elev)
tan(elev)

asin(elev)
acos(elev)
atan(elev)

atan(elevs)
atan2(elev, elev^1.2)
atan2(elevs, elev^1.2)
atan2(elev, elevs^1.2)
atan2(elevs, elevs^1.2)

# logarithms
exp(elev)
log(elev)
ln(elev)
log2(elev)
log1p(elev)
log10(elev)
log10p(elev)
log(elev, 3)

log(elevs)

# rounding
round(elev + 0.5)
floor(elev + 0.5)
ceiling(elev + 0.5)
trunc(elev + 0.5)

}
}
