% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop.r
\name{crop,GRaster-method}
\alias{crop,GRaster-method}
\alias{crop}
\alias{crop,GVector-method}
\title{Remove parts of a GRaster or GVector}
\usage{
\S4method{crop}{GRaster}(x, y, fail = TRUE)

\S4method{crop}{GVector}(x, y, extent = FALSE, fail = TRUE)
}
\arguments{
\item{x}{A \code{GRaster} or \code{GVector} to be cropped.}

\item{y}{A \code{GRaster} or \code{GVector} to serve as a template for cropping.}

\item{fail}{Logical: If \code{TRUE} (default), and the cropped object would have zero extent in at least one dimension, then exit the function with an error. If \code{FALSE}, then display a warning and return \code{NULL}.}

\item{extent}{Logical:
\itemize{
\item If \code{y} is a "points" \code{GVector}: Use the convex hull around \code{y} to crop \code{x}.
\item If \code{y} is a "lines" or "polygons" \code{GVector}: If \code{TRUE}, use the extent of \code{y} to crop \code{x}.
\item if \code{y} is a \code{GVector}, \code{x} will be cropped to the extent of \code{y} (\code{extent} is ignored).
}}
}
\value{
A \code{GRaster} or \code{GVector} (or \code{NULL} if \code{fail} is \code{FALSE} and the output would have a zero east-west and/or north-south extent).
}
\description{
\code{crop()} removes parts of a \code{GRaster} or \code{GVector} that fall "outside" another raster or vector. You cannot make the \code{GRaster} or \code{GVector} larger than it already is (see \code{\link[=extend]{extend()}}). Rasters may not be cropped to the exact extent, as the extent will be enlarged to encompass an integer number of cells. If you wish to remove certain cells of a raster, see \code{\link[=mask]{mask()}}.
}
\details{
Known differences from \code{\link[terra:crop]{terra::crop()}}:
\itemize{
\item If \code{x} and \code{y} are "points" vectors, and \code{extent} is \code{TRUE}, \strong{terra} removes points that fall on the extent boundary. \strong{fasterRaster} does not remove points on the extent boundary.
\item If \code{x} is a "points" vector and \code{y} is a "lines" vectors, and \code{extent} is \code{FALSE}, \strong{terra} uses the extent of \code{y} to crop the points.  \strong{fasterRaster} uses the minimum convex hull of the lines vector.
}
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Elevation raster
madElev <- fastData("madElev")

# Plant specimen points vector
madDypsis <- fastData("madDypsis")

# Rivers lines vector
madRivers <- fastData("madRivers")

# Polygons vector
madCoast4 <- fastData("madCoast4")
madAnt <- madCoast4[madCoast4$NAME_4 == "Antanambe", ]

# Convert to fasterRaster format:
elev <- fast(madElev)
dypsis <- fast(madDypsis)
rivers <- fast(madRivers)
coast <- fast(madCoast4)
ant <- fast(madAnt)

### Crop raster by vector:
rastByVect <- crop(elev, ant)
plot(elev, col = "gray", legend = FALSE)
plot(rastByVect, add = TRUE)
plot(ant, add = TRUE)

### Crop raster by raster:

# For this example, make the SpatRaster smaller, then crop by this.
templateRast <- crop(madElev, madAnt)

template <- fast(templateRast)
rastByRast <- crop(elev, template)

plot(elev, col = "gray", legend = FALSE)
plot(rastByRast, add = TRUE)

### Crop vector by raster:

# For this example, make the SpatRaster smaller, then crop by this.
templateRast <- crop(madElev, madAnt)

template <- fast(templateRast)
ptsByRast <- crop(dypsis, template)

plot(elev, col = "gray", legend = FALSE)
plot(templateRast, add = TRUE)
plot(dypsis, add = TRUE)
plot(ptsByRast, pch = 21, bg = "red", add = TRUE)

### Crop vector by vector:
ptsSubset <- dypsis[1:10] # use first 10 points as cropping template

# Crop points vector by convex hull around points:
ptsByPts <- crop(dypsis, ptsSubset)
plot(dypsis)
plot(convHull(ptsSubset), lty = "dotted", border = "blue", add = TRUE)
plot(ptsByPts, col = "red", add = TRUE)
plot(ptsSubset, col = "blue", pch = 3, cex = 1.6, add = TRUE)
legend("topleft",
    legend = c("Dypsis", "Selected", "Crop template", "Convex hull"),
    pch = c(16, 16, 3, NA),
    lwd = c(NA, NA, NA, 1),
    col = c("black", "red", "blue", "blue"),
    lty = c(NA, NA, NA, "dotted"),
    xpd = NA,
    bg = "white"
)

# Crop points vector by extent of points:
ptsByPts <- crop(dypsis, ptsSubset, ext = TRUE)
plot(dypsis)
plot(ptsByPts, col = "red", add = TRUE)
plot(ptsSubset, col = "blue", pch = 3, cex = 1.6, add = TRUE)
legend("topleft",
    legend = c("Dypsis", "Selected", "Crop template"),
    pch = c(16, 16, 3),
    lwd = c(NA, NA, NA),
    col = c("black", "red", "blue"),
    lty = c(NA, NA, NA),
    xpd = NA,
    bg = "white"
)

# Crop points vector by convex hull around lines:
ptsByPts <- crop(dypsis, rivers)
plot(rivers, col = "blue", pch = 3, cex = 1.6)
plot(dypsis, add = TRUE)
plot(convHull(rivers), lty = "dotted", border = "blue", add = TRUE)
plot(ptsByPts, col = "red", add = TRUE)
legend("topleft",
    legend = c("Dypsis", "Selected", "Rivers", "Convex hull"),
    pch = c(16, 16, NA, NA),
    lwd = c(NA, NA, 1, 1),
    col = c("black", "red", "blue", "blue"),
    lty = c(NA, NA, "solid", "dotted"),
    xpd = NA,
    bg = "white"
)

# Crop points vector by extent of lines:
ptsByPts <- crop(dypsis, rivers, ext = TRUE)
plot(rivers, col = "blue", pch = 3, cex = 1.6)
plot(dypsis, add = TRUE)
plot(convHull(rivers), lty = "dotted", border = "blue", add = TRUE)
plot(ptsByPts, col = "red", add = TRUE)
legend("topleft",
    legend = c("Dypsis", "Selected", "Rivers"),
    pch = c(16, 16, NA),
    lwd = c(NA, NA, 1),
    col = c("black", "red", "blue"),
    lty = c(NA, NA, "solid"),
    xpd = NA,
    bg = "white"
)

# Crop points vector by polygon:
ptsByPts <- crop(dypsis, ant)
plot(dypsis)
plot(ant, border = "blue", pch = 3, cex = 1.6, add = TRUE)
plot(ptsByPts, col = "red", add = TRUE)
legend("topleft",
    legend = c("Dypsis", "Selected", "Antanambe"),
    pch = c(16, 16, NA),
    lwd = c(NA, NA, 1),
    col = c("black", "red", "blue"),
    lty = c(NA, NA, "solid"),
    xpd = NA,
    bg = "white"
)

# Crop lines vector by polygon:
linesByPoly <- crop(rivers, ant)
plot(rivers)
plot(ant, border = "blue", pch = 3, cex = 1.6, add = TRUE)
plot(linesByPoly, col = "red", add = TRUE)
legend("topleft",
    legend = c("Rivers", "Selected", "Antanambe"),
    col = c("black", "red", "blue"),
    lwd = 1,
    xpd = NA,
    bg = "white"
)

# Crop polygon vector by convex hull around points:
polyByPoints <- crop(ant, dypsis)
plot(dypsis, col = "red")
plot(ant, border = "blue", add = TRUE)
plot(polyByPoints, border = "red", add = TRUE)
legend("topleft",
    legend = c("Dypsis", "Antanambe", "Selected"),
    col = c("red", "blue", "red"),
    pch = c(16, NA, NA),
    lwd = c(NA, 1, 1),
    xpd = NA,
    bg = "white"
)

}
}
\seealso{
\code{\link[terra:crop]{terra::crop()}}, \code{\link[sf:st_crop]{sf::st_crop()}}
}
