% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.lonlat.r
\name{is.lonlat,character-method}
\alias{is.lonlat,character-method}
\alias{is.lonlat}
\alias{is.lonlat,GLocation-method}
\alias{is.lonlat,sf-method}
\title{Test if a coordinate reference system is unprojected}
\usage{
\S4method{is.lonlat}{character}(x)

\S4method{is.lonlat}{GLocation}(x)

\S4method{is.lonlat}{sf}(x)
}
\arguments{
\item{x}{A WKT coordinate reference string or an object from which on can be obtained (e.g., a \code{GRaster}, \code{GVector}, \code{GRegion}, \code{GLocation}, \code{SpatRaster}, \code{SpatVector}, or \code{sf} object).}
}
\value{
Logical (\code{TRUE} if unprojected, \code{FALSE} otherwise).
}
\description{
\code{is.lonlat()} attempts to determine if a coordinate reference system is unprojected (e.g., WGS84, NAD83, NAD27, etc.). For \code{GRaster}s and \code{GVector}s, the function should always be correct. For WKT character strings and \code{sf} vectors, it does this by looking for the "CONVERSION[" tag in the WKT string (or the object's WKT string), and if it finds one, returns \code{FALSE}. This may not be truthful in all cases.
}
\seealso{
\code{\link[terra:is.lonlat]{terra::is.lonlat()}}
}
