% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.r
\name{merge,GRaster,GRaster-method}
\alias{merge,GRaster,GRaster-method}
\alias{merge}
\title{Combine two or more rasters with different extents and fill in NAs}
\usage{
\S4method{merge}{GRaster,GRaster}(x, y, ...)
}
\arguments{
\item{x, y, ...}{\code{GRaster}s.}
}
\value{
A \code{GRaster}.
}
\description{
\code{merge()} combines two or more \code{GRaster}s, possibly with different extents, into a single larger \code{GRaster}. Where the same cell has different values in each raster, the value of the first raster's cell is used. If this is \code{NA}, then the value of the second raster's cell is used, and so on.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Example data
madElev <- fastData("madElev")
madCoast4 <- fastData("madCoast4")
madCoast4 <- vect(madCoast4)

# For the example, crop the elevation raster to two communes
madAnt <- madCoast4[madCoast4$NAME_4 == "Antanambe", ]
madMan <- madCoast4[madCoast4$NAME_4 == "Manompana", ]

elevAnt <- crop(madElev, madAnt)
elevMan <- crop(madElev, madMan)

plot(madElev)
plot(elevAnt, col = "red", legend = FALSE, add = TRUE)
plot(elevMan, col = "blue", legend = FALSE, add = TRUE)

# Convert a SpatRaster to a GRaster
ant <- fast(elevAnt)
man <- fast(elevMan)

# merge
antMan <- merge(ant, man)
plot(antMan, main = "Antman!")

}
}
\seealso{
\code{\link[terra:merge]{terra::merge()}}, \code{\link[terra:mosaic]{terra::mosaic()}}, and \strong{GRASS} tool \code{r.patch}
}
