% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ranef.R
\name{add_between}
\alias{add_between}
\title{Add between factors}
\usage{
add_between(.data, .by = NULL, ..., .shuffle = FALSE, .prob = NULL)
}
\arguments{
\item{.data}{the data frame}

\item{.by}{the grouping column (groups by row if NULL)}

\item{...}{the names and levels of the new factors}

\item{.shuffle}{whether to assign cells randomly or in "order"}

\item{.prob}{probability of each level, equal if NULL}
}
\value{
data frame
}
\description{
Add between factors
}
\examples{
add_random(subj = 4, item = 2) \%>\%
  add_between("subj", condition = c("cntl", "test")) \%>\%
  add_between("item", version = c("A", "B"))
}
