% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fec16-package.R
\docType{package}
\name{fec16}
\alias{fec16-package}
\alias{fec16}
\title{fec16: A Data Package for the 2016 Elections}
\description{
The fec16 package provides the following 9 datasets from the Federal Election Commission's 2015-2016 election cycle:
}
\section{Datasets}{

\if{html}{\figure{hex_fec16.png}{options: style="float: right" width=120 alt="Figure: hex_fec16.png"}}
\itemize{
\item Candidates: \link{candidates}
\item Committees: \link{committees}
\item House Results: \link{results_house}
\item Senate Results: \link{results_senate}
\item Presidential Results: \link{results_president}
\item Individual Contributions: \link{individuals}
\item Committee Contributions: \link{contributions}
\item House/Senate Current Campaigns: \link{campaigns}
\item Operating Expenditures: \link{expenditures}
\item Transactions From One Committee To Another: \link{transactions}
\item Political Action Committee (PAC) and Party Summary Financial Information: \link{pac}}

The entire \link{candidates}, \link{committees}, \link{campaigns}, \link{results_house}, \link{results_senate}, \link{results_president}, and \link{pac} datasets and samples containing 1000 entries of the other datasets are available directly in the package.
For the datasets containing samples, full versions can be retrieved via the following functions:
\itemize{
\item Individual Contributions: \link{read_all_individuals}
\item Committee Contributions: \link{read_all_contributions}
\item Operating Expenditures: \link{read_all_expenditures}
\item Transactions From One Committee To Another: \link{read_all_transactions}
}

In addition, \code{fec16} provides the \link{states} dataset giving geographical information about the 50 states.
}

\section{Authors}{

\itemize{
\item Marium Tapal: \url{https://github.com/mariumtapal}
\item Irene Ryan: \url{https://github.com/ireneryan}
\item Rana Gahwagy: \url{https://github.com/ranawg}
\item Ben Baumer: \url{https://github.com/beanumber}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/baumer-lab/fec16}
  \item Report bugs at \url{https://github.com/baumer-lab/fec16/issues}
}

}
\author{
\strong{Maintainer}: Marium Tapal \email{mariumtapal@gmail.com} (\href{https://orcid.org/0000-0001-5093-6462}{ORCID})

Authors:
\itemize{
  \item Rana Gahwagy \email{r.w.g1@hotmail.com}
  \item Irene Ryan \email{ryan.irene3@gmail.com}
  \item Benjamin S. Baumer \email{ben.baumer@gmail.com} (\href{https://orcid.org/0000-0002-3279-0516}{ORCID})
}

}
