% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/details.R
\name{felt_update_layer_group_details}
\alias{felt_update_layer_group_details}
\title{Update a Layer Group's Details}
\usage{
felt_update_layer_group_details(
  map_id,
  layer_group_id,
  name = NULL,
  ordering_key = NULL,
  subtitle = NULL,
  clean = TRUE
)
}
\arguments{
\item{map_id}{character, map identifier from url, from \verb{https://felt.com/map/Readable-Name-map_id}}

\item{layer_group_id}{character, layer group identifier from url, from \code{felt_get_map()}.}

\item{name}{Name of the layer group. Required.}

\item{ordering_key}{Integer to order by. Defaults to \code{NULL}.}

\item{subtitle}{Subtitle for the layer group. Defaults to \code{NULL}.}

\item{clean}{logical, whether to turn the API response into a \link[tibble:tibble]{tibble::tibble}}
}
\value{
response data
}
\description{
Allows for updates to the name, ordering key, and subtitle.
}
\examples{
\dontshow{if (has_felt_key()) withAutoprint(\{ # examplesIf}
felt_update_layer_group_details(map_id = 'TBI8sDkmQjuK2GX9CSiHiUA',
                               layer_group_id = 'rHxyTef7S9CO8W7n1PvBVwC',
                               name = 'Polling Sites 2020',
                               subtitle = paste0('tested ', Sys.Date()))
\dontshow{\}) # examplesIf}
}
\concept{get}
