% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-sffa-estimates.R
\name{plot_sffa_estimates}
\alias{plot_sffa_estimates}
\title{Plot Estimated Return Levels for S-FFA}
\usage{
plot_sffa_estimates(results, periods = c(2, 5, 10, 20, 50, 100), ...)
}
\arguments{
\item{results}{A fitted flood frequency model generated by \code{\link[=fit_lmoments]{fit_lmoments()}},
\code{\link[=fit_mle]{fit_mle()}} or \code{\link[=fit_gmle]{fit_gmle()}} OR a fitted model with confidence intervals generated
by \code{\link[=uncertainty_bootstrap]{uncertainty_bootstrap()}}, \code{\link[=uncertainty_rfpl]{uncertainty_rfpl()}}, or \code{\link[=uncertainty_rfgpl]{uncertainty_rfgpl()}}.}

\item{periods}{Numeric vector used to set the return periods for FFA.
All entries must be greater than or equal to 1.}

\item{...}{Optional named arguments: 'title', 'xlabel', and 'ylabel'.}
}
\value{
\code{ggplot}; a plot showing:
\itemize{
\item A solid black line for the point estimates produced by the model.
\item A semi-transparent gray ribbon indicating the confidence interval, if given.
}
}
\description{
Generates a plot with return periods on the x-axis and return levels (annual
maxima magnitudes) on the y-axis for S-FFA. The confidence bound is shown as a
semi-transparent ribbon, and the point estimates are overlaid as a solid line.
Return periods are shown on a logarithmic scale.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
years <- seq(from = 1901, to = 2000)
results <- fit_lmoments(data, "WEI")
plot_sffa_estimates(results)

}
