% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select-lkurtosis.R
\name{select_lkurtosis}
\alias{select_lkurtosis}
\title{L-Kurtosis Method for Distribution Selection}
\usage{
select_lkurtosis(data, ns_years = NULL, ns_structure = NULL)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{ns_years}{For NS-FFA only: Numeric vector of observation years corresponding
to \code{data}. Must be the same length as \code{data} and strictly increasing.}

\item{ns_structure}{For NS-FFA only: Named list indicating which distribution
parameters are modeled as nonstationary. Must contain two logical scalars:
\itemize{
\item \code{location}: If \code{TRUE}, the location parameter has a linear temporal trend.
\item \code{scale}: If \code{TRUE}, the scale parameter has a linear temporal trend.
}}
}
\value{
A list with the results of distribution selection:
\itemize{
\item \code{method}: \code{"L-kurtosis"}.
\item \code{decomposed_data}: The detrended dataset used to compute the L-moments. For S-FFA,
this is the \code{data} argument. For NS-FFA, it is output of \code{\link[=data_decomposition]{data_decomposition()}}.
\item \code{metrics}: A list of L-kurtosis metrics for each distribution.
\item \code{recommendation}: Name of the distribution with the smallest L-kurtosis metric.
}
}
\description{
Selects a probability distribution by minimizing the absolute distance
between the theoretical L-kurtosis (\eqn{\tau_4}) and the sample L-kurtosis
(\eqn{t_4}). Only supports 3-parameter distributions.

\strong{For NS-FFA}: To select a distribution for a nonstationary model, include the
observation years (\code{ns_years}) and the nonstationary model structure
(\code{ns_structure}). Then, this method will detrend the original, nonstationary data
internally using the \code{\link[=data_decomposition]{data_decomposition()}} function prior to distribution selection.
}
\details{
This method computes the distance between the sample and theoretical L-kurtosis
values at a fixed L-skewness. For three parameter distributions, the shape parameter
that best replicates the sample L-skewness is determined using \code{\link[stats:optim]{stats::optim()}}.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
select_lkurtosis(data)

}
\references{
Hosking, J.R.M. & Wallis, J.R., 1997. Regional frequency analysis: an approach based
on L-Moments. Cambridge University Press, New York, USA.
}
\seealso{
\code{\link[=utils_sample_lmoments]{utils_sample_lmoments()}}, \code{\link[=select_ldistance]{select_ldistance()}}, \code{\link[=select_zstatistic]{select_zstatistic()}},
\code{\link[=plot_lmom_diagram]{plot_lmom_diagram()}}
}
