% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bkg_non_admin.R
\name{bkg_ror}
\alias{bkg_ror}
\alias{bkg_rg}
\alias{bkg_amr}
\alias{bkg_bkr}
\alias{bkg_krg}
\alias{bkg_mbe}
\alias{bkg_ggr}
\alias{bkg_kmr}
\alias{bkg_mkro}
\title{Non-administrative regions}
\usage{
bkg_ror(
  scale = c("250", "1000", "2500", "5000"),
  year = "latest",
  timeout = 120,
  update_cache = FALSE
)

bkg_rg(
  scale = c("250", "1000", "2500", "5000"),
  year = "latest",
  timeout = 120,
  update_cache = FALSE
)

bkg_amr(
  scale = c("250", "1000", "2500", "5000"),
  year = "latest",
  timeout = 120,
  update_cache = FALSE
)

bkg_bkr(
  scale = c("250", "1000", "2500", "5000"),
  year = "latest",
  timeout = 120,
  update_cache = FALSE
)

bkg_krg(
  scale = c("250", "1000", "2500", "5000"),
  year = "latest",
  timeout = 120,
  update_cache = FALSE
)

bkg_mbe(
  scale = c("250", "1000", "2500", "5000"),
  year = "latest",
  timeout = 120,
  update_cache = FALSE
)

bkg_ggr(
  scale = c("250", "1000", "2500", "5000"),
  year = "latest",
  timeout = 120,
  update_cache = FALSE
)

bkg_kmr(
  scale = c("250", "1000", "2500", "5000"),
  year = "latest",
  timeout = 120,
  update_cache = FALSE
)

bkg_mkro(
  scale = c("250", "1000", "2500", "5000"),
  year = "latest",
  timeout = 120,
  update_cache = FALSE
)
}
\arguments{
\item{scale}{Scale of the geometries. Can be \code{"250"}
(1:250,000), \code{"1000"} (1:1,000,000), \code{"2500"} (1:2,500,000)
or \code{"5000"} (1:5,000,000). If \code{"250"}, population data is included
in the output. Defaults to \code{"250"}.}

\item{year}{Version year of the dataset. You can use \code{latest} to
retrieve the latest dataset version available on the BKG's geodata center.
Older versions can be browsed using the
\href{https://daten.gdz.bkg.bund.de/produkte/}{archive}.}

\item{timeout}{Timeout value for the data download passed to
\code{\link[httr2]{req_timeout}}. Adjust this if your internet connection is
slow or you are downloading larger datasets.}

\item{update_cache}{By default, downloaded files are cached in the
\code{tempdir()} directory of R. When downloading the same data again,
the data is not downloaded but instead taken from the cache. Sometimes
this can be not the desired behavior. If you want to overwrite the cache,
pass \code{TRUE}. Defaults to \code{FALSE}, i.e. always adopt the cache
if possible.}
}
\value{
An sf tibble with multipolygon geometries and two features,
a regional identifier and the region endonyms.
}
\description{
Retrieve areal data related to what the BKG calls non-administrative
regions. This includes:

\itemize{
\item{\code{bkg_ror}: Raumordnungsregionen (Spatial planning regions)}
\item{\code{bkg_rg}: Reisegebiete (Travel areas)}
\item{\code{bkg_amr}: Arbeitsmarktregionen (Labor market regions)}
\item{\code{bkg_bkr}: Braunkohlereviere (Lignite regions)}
\item{\code{bkg_krg}: Kreisregionen (District regions)}
\item{\code{bkg_mbe}: BBSR Mittelbereiche (BBSR middle areas)}
\item{\code{bkg_ggr}: Großstadtregionen (City regions)}
\item{\code{bkg_kmr}: Metropolregionen (Metropolitan regions)}
\item{\code{bkg_mkro}: Verdichtungsräume (Conurbations)}
}

These functions interface the \code{ge*} product of the BKG.
}
\seealso{
\href{https://sgx.geodatenzentrum.de/web_public/gdz/dokumentation/deu/ge5000.pdf}{\code{ge5000 documentation}}

\href{https://mis.bkg.bund.de/trefferanzeige?docuuid=A79091B8-5E32-4300-8B19-517195FF8084}{\code{ge5000} MIS record}

Other non-administrative regions: 
\code{\link{bkg_area_codes}()},
\code{\link{bkg_authorities}()},
\code{\link{bkg_grid}},
\code{\link{bkg_kfz}()}
}
\concept{non-administrative regions}
