% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_USVT.R
\name{fill.USVT}
\alias{fill.USVT}
\title{Matrix Completion by Universal Singular Value Thresholding}
\usage{
fill.USVT(A, eta = 0.01)
}
\arguments{
\item{A}{an \eqn{(n\times p)} partially observed matrix.}

\item{eta}{control for thresholding \eqn{\in (0,1)}.}
}
\value{
a named list containing \describe{
\item{X}{an \eqn{(n\times p)} estimated matrix after completion, which is \eqn{\hat{A}} in the equation above.}
}
}
\description{
\code{fill.USVT} is a matrix \emph{estimation} method suitable for low-rank structure. In the context of
our package, we provide this method under the matrix \emph{completion} problem category. It aims at
exploiting the idea of thresholding the singular values to minimize the mean-squared error, defined as
\deqn{\mathrm{MSE}(\hat{A}):={E} \left\{ \frac{1}{np} \sum_{i=1}^{n} \sum_{j=1}^{p} (\hat{a}_{ij} - a_{ij})^2  \right\}}
where \eqn{A} is an \eqn{(n\times p)} matrix with some missing values and \eqn{\hat{A}} is an estimate.
}
\examples{
\dontrun{
## load image data of 'lena128'
data(lena128)

## transform 5\% of entries into missing
set.seed(5)
A <- aux.rndmissing(lena128, x=0.05)

## apply the method with 3 different control 'eta'
fill1 <- fill.USVT(A, eta=0.01)
fill2 <- fill.USVT(A, eta=0.5)
fill3 <- fill.USVT(A, eta=0.99)

## visualize only the last ones from each run
opar <- par(no.readonly=TRUE)
par(mfrow=c(2,2), pty="s")
image(A, col=gray((0:100)/100), axes=FALSE, main="5\% missing")
image(fill1$X, col=gray((0:100)/100), axes=FALSE, main="eta=0.01")
image(fill2$X, col=gray((0:100)/100), axes=FALSE, main="eta=0.5")
image(fill3$X, col=gray((0:100)/100), axes=FALSE, main="eta=0.99")
par(opar)
}

}
\references{
\insertRef{chatterjee2015}{filling}
}
