% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_group_members.R
\name{get_group_members}
\alias{get_group_members}
\title{Get members of a specific concept group from the Finto Skosmos API}
\usage{
get_group_members(vocid, uri, lang = NULL)
}
\arguments{
\item{vocid}{The vocabulary ID, e.g., "yso".}

\item{uri}{The URI of the concept group whose members to retrieve.}

\item{lang}{The language code for the labels, e.g., "fi" or "en". Optional.}
}
\value{
A tibble containing members associated with the specified concept group.
}
\description{
Get members of a specific concept group from the Finto Skosmos API
}
\examples{
group_members_data <- get_group_members(vocid = "yso",
uri = "http://www.yso.fi/onto/yso/p26580", lang = "fi")
print(head(group_members_data))
}
