% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guard_key.R
\name{guard_key}
\alias{guard_key}
\title{Shared secret guard}
\usage{
guard_key(
  key_name,
  validate,
  user_info = NULL,
  cookie = TRUE,
  name = "KeyAuth"
)
}
\arguments{
\item{key_name}{The name of the header or cookie to store the secret under}

\item{validate}{Either a single string with the secret
or a function that will be called with the arguments \code{key}, \code{request}, and
\code{response} and returns \code{TRUE} if its a valid secret (useful if you have
multiple or rotating secrets). If the function returns a character vector it
is considered to be authenticated and the return value will be understood as
scopes the user is granted. Make sure never to store secrets in plain text
and avoid checking them into version control.}

\item{user_info}{A function to extract user information from the
key. It is called with a single argument: \code{key} which is the key
used for the successful authentication. The function should return a new
\link[=new_user_info]{user_info} list.}

\item{cookie}{Boolean. Should the secret be transmitted as a cookie. If
\code{FALSE} it is expected to be transmitted as a header.}

\item{name}{The name of the guard}
}
\value{
A \link{GuardKey} object
}
\description{
This guard is based on a mutually shared secret between the
server and the client. The client provides the secret either as a header or
in a cookie, and the server verifies the authenticity of the secret. Like
with \link[=guard_basic]{basic authentication}, this scheme relies on additional
technology like HTTPS/SSL to make it secure since the secret can otherwise
easily be extracted from the request by man-in-the-middle attack.
}
\details{
This authentication is not a classic HTTP authentication scheme and thus
doesn't return a \code{401} response with a \code{WWW-Authenticate} header. Instead it
returns a \code{400} response unless another guard has already set the
response status to something else.
}
\section{User information}{
\code{guard_key()} automatically adds \link[=new_user_info]{user information} after
authentication. By default it will set the \code{provider} field to \code{"local"}.
Further, it will set the \code{scopes} field to any scopes returned by the
\code{validate} function (provided \code{validate} is passed a function).

Since key-based authentication is seldom used with user specific keys it is
unlikely that it makes sense to populate the information any further.
}

\examples{
# Create a guard of dubious quality
key <- guard_key(
  key_name = "my-key-location",
  validate = "SHHH!!DONT_TELL_ANYONE"
)

# Add it to a fireproof plugin
fp <- Fireproof$new()
fp$add_guard(key, "key_auth")

# Use it in an endpoint
fp$add_auth("get", "/*", key_auth)

}
