% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_info.R
\name{new_user_info}
\alias{new_user_info}
\title{Well structured user information}
\usage{
new_user_info(
  provider = NULL,
  id = NULL,
  name_display = NULL,
  name_given = NULL,
  name_middle = NULL,
  name_family = NULL,
  name_user = NULL,
  emails = NULL,
  photos = NULL,
  ...
)
}
\arguments{
\item{provider}{A string naming the provider of the user information}

\item{id}{A unique identifier of this user}

\item{name_display, name_given, name_middle, name_family, name_user}{The legal
name of the user. Will be combined to a single \code{name} field in the output
with the structure
\code{c(given = name_given, middle = name_middle, family = name_family, display = name_display, user = name_user)}}

\item{emails}{A character vector of emails to the user. The vector can be
named in which case the names correspond to the category of email, e.g.
"work", "home" etc.}

\item{photos}{A character vector of urls pointing to profile pictures of the
user.}

\item{...}{Additional named arguments to be added to the user information}
}
\value{
A list of class \code{fireproof_user_info}. The fields of the list are as
provided in the arguments except for the \verb{name_*} arguments which will be
combined to a single field. See the description of these arguments for more
information.
}
\description{
Different services and authentication schemes may present user information in
different ways. To ensure ease of interoperability, fireproof will attempt to
standardize the information as it gets extracted by the service. This
function is intended to be called to construct the output of \code{user_info}
function.
}
\section{Setting user information}{
Each authentication scheme will write to a field in the session data store
named after its own name. What gets written can sometimes be influenced by
the user by passing in a function to the \code{user_info} argument of the
constructor. This output of this function will be combined with default
information from the guard before being saved in the session storage (e.g.
the \code{scopes} field is always created automatically).
}

\examples{
new_user_info(
  provider = "local",
  id = 1234,
  name_display = "thomasp85",
  name_given = "Thomas",
  name_middle = "Lin",
  name_family = "Pedersen"
)


}
