% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_combine.R
\name{light_combine}
\alias{light_combine}
\alias{light_combine.default}
\alias{light_combine.light}
\alias{light_combine.list}
\title{Combine Objects}
\usage{
light_combine(x, ...)

\method{light_combine}{default}(x, ...)

\method{light_combine}{light}(x, new_class = NULL, ...)

\method{light_combine}{list}(x, new_class = NULL, ...)
}
\arguments{
\item{x}{A list of objects of the same class.}

\item{...}{Further arguments passed from or to other methods.}

\item{new_class}{An optional vector with additional class names to be added
to the output.}
}
\value{
If \code{x} is a list, an object like each element but with unioned rows
in data slots.
}
\description{
Combines a list of similar objects each of class "light" by row binding
\code{data.frame} slots and retaining the other slots from the first list element.
}
\section{Methods (by class)}{
\itemize{
\item \code{light_combine(default)}: Default method not implemented yet.

\item \code{light_combine(light)}: Since there is nothing to combine, the input is returned
except for additional classes.

\item \code{light_combine(list)}: Combine a list of similar light objects.

}}
\examples{
fit_lm <- lm(Sepal.Length ~ ., data = iris)
fit_glm <- glm(Sepal.Length ~ ., family = Gamma(link = "log"), data = iris)
mod_lm <- flashlight(model = fit_lm, label = "lm", data = iris, y = "Sepal.Length")
mod_glm <- flashlight(
  model = fit_glm,
  label = "glm",
  data = iris,
  y = "Sepal.Length",
  predict_function = function(object, newdata)
    predict(object, newdata, type = "response")
)
mods <- multiflashlight(list(mod_lm, mod_glm))
perf_lm <- light_performance(mod_lm)
perf_glm <- light_performance(mod_glm)
manual_comb <- light_combine(
  list(perf_lm, perf_glm),
  new_class = "light_performance_multi"
)
auto_comb <- light_performance(mods)
all.equal(manual_comb, auto_comb)
}
