% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppoislogn.R
\name{PoissonLognormal}
\alias{PoissonLognormal}
\alias{dpLnorm}
\alias{ppLnorm}
\alias{qpLnorm}
\alias{rpLnorm}
\title{Poisson-Lognormal Distribution}
\usage{
dpLnorm(x, mean = 1, sigma = 1, ndraws = 1500, log = FALSE, hdraws = NULL)

ppLnorm(
  q,
  mean = 1,
  sigma = 1,
  ndraws = 1500,
  lower.tail = TRUE,
  log.p = FALSE
)

qpLnorm(p, mean = 1, sigma = 1, ndraws = 1500)

rpLnorm(n, mean = 1, sigma = 1, ndraws = 1500)
}
\arguments{
\item{x}{numeric value or a vector of values.}

\item{mean}{numeric value or vector of mean values for the distribution (the
values have to be greater than 0).}

\item{sigma}{single value or vector of values for the sigma parameter of the
lognormal distribution (the values have to be greater than 0).}

\item{ndraws}{the number of Halton draws to use for the integration.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{hdraws}{and optional vector of Halton draws to use for the integration.}

\item{q}{quantile or a vector of quantiles.}

\item{lower.tail}{logical; if TRUE, probabilities p are \eqn{P[X\leq x]}
otherwise, \eqn{P[X>x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{probability or a vector of probabilities.}

\item{n}{the number of random numbers to generate.}
}
\value{
dpLnorm gives the density, ppLnorm gives the distribution 
 function, qpLnorm gives the quantile function, and rpLnorm generates
 random  deviates.

 The length of the result is determined by n for rpLnorm, and is the 
 maximum of the lengths of the numerical arguments for the other functions.
}
\description{
These functions provide density, distribution function, quantile function,
and random number generation for the Poisson-Lognormal (PLogN) Distribution
}
\details{
\code{dpLnorm} computes the density (PDF) of the Poisson-Lognormal
Distribution.

\code{ppLnorm} computes the CDF of the Poisson-Lognormal Distribution.

\code{qpLnorm} computes the quantile function of the Poisson-Lognormal
Distribution.

\code{rpLnorm} generates random numbers from the Poisson-Lognormal
Distribution.

The compound Probability Mass Function (PMF) for the Poisson-Lognormal
distribution is:
\deqn{f(y|\mu,\theta,\alpha)=
  \int_0^\infty \frac{\mu^y x^y e^{-\mu x}}{y!} 
  \frac{exp\left(-\frac{ln^2(x)}{2\sigma^2} \right)}{x\sigma\sqrt{2\pi}}dx}

Where \eqn{\sigma} is a parameter for the lognormal distribution with the
restriction \eqn{\sigma>0}, and \eqn{y} is a non-negative integer.

The expected value of the distribution is:
\deqn{E[y]=e^{X\beta+\sigma^2/2} = \mu e^{\sigma^2/2}}
Halton draws are used to perform simulation over the lognormal distribution
to solve the integral.
}
\examples{
dpLnorm(0, mean=0.75, sigma=2, ndraws=10)
ppLnorm(c(0,1,2,3,5,7,9,10), mean=0.75, sigma=2, ndraws=10)
qpLnorm(c(0.1,0.3,0.5,0.9,0.95), mean=0.75, sigma=2, ndraws=10)
rpLnorm(30, mean=0.75,  sigma=2, ndraws=10)

}
