% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regCompTable.R
\name{regCompTable}
\alias{regCompTable}
\title{Create a Table Comparing Regression Models with AIC, BIC, and McFadden's
Pseudo-R-Squared}
\usage{
regCompTable(
  models,
  coefs = TRUE,
  AIC = TRUE,
  BIC = TRUE,
  RSquare = TRUE,
  tableType = "tibble",
  digits = 3
)
}
\arguments{
\item{models}{A named list of fitted flexCountReg model objects. This must
include 2 or more models.}

\item{coefs}{A logical. The default value `TRUE` indicates that the
coefficients from the models should be included in the table of
comparisons.}

\item{AIC}{A logical. The default value `TRUE` indicates that AIC values for
the models should be included.}

\item{BIC}{A logical. The default value `TRUE` indicates that BIC values for
the models should be included.}

\item{RSquare}{A logical. The default value `TRUE` indicates that the
McFadden's Pseudo-R-Squared statistic (comparing against a Poisson
regression model) should be included.}

\item{tableType}{The type of table format to return. Options include "tibble"
for returning the table as a tibble, "gt" for a \link[gt]{gt} table object,
or "latex" for a latex table. The default is "tibble".}

\item{digits}{An integer value indicating the number of decimals to round the
table values to.}
}
\value{
A table comparing the models supplied to the function in the format 
 specified The table includes coefficients, standard errors, statistical 
 significance, AIC, BIC, and McFadden's Pseudo-R-Squared. Table formats 
 include: "tibble", "gt", and "latex".
}
\description{
This function creates tables comparing the flexCountReg package models
supplied to the function.
}
\examples{

# Comparing the NBP model with the NB2 and NB1 models
data("washington_roads")
washington_roads$AADTover10k <- ifelse(washington_roads$AADT>10000,1,0)

nb.1 <- countreg(Total_crashes ~ lnaadt + lnlength + speed50 +
                    ShouldWidth04 + AADTover10k,
                    data=washington_roads, family = 'NB1', method = 'NM')
                    
nb.2 <- countreg(Total_crashes ~ lnaadt + lnlength + speed50 +
                    ShouldWidth04 + AADTover10k,
                    data=washington_roads, family = 'NB2', method = 'NM')
                    
                    
nb.p <- countreg(Total_crashes ~ lnaadt + lnlength + speed50 +
                    ShouldWidth04 + AADTover10k,
                    data=washington_roads, family = 'NBP', method = 'NM')
                    
                    
comptable <- 
 regCompTable(list("NB-1"=nb.1, "NB-2"=nb.2, "NB-P"=nb.p), tableType="latex")
print(comptable)
}
