% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_flexCountReg.R
\name{summary.flexCountReg}
\alias{summary.flexCountReg}
\title{Custom summary method for flexCountReg models}
\usage{
\method{summary}{flexCountReg}(object, ...)
}
\arguments{
\item{object}{A flexCountReg model object.}

\item{...}{Optional parameters that include `confint_level` and `digits`.}
}
\value{
Prints the model formula, method used for estimation, number of 
 iterations used, if the model converged, and the log-likelihood. Then, it 
 prints a table containing parameter estimates, standard errors, 
 t-statistics, p-values, and confidence intervals. Also quietly returns a 
 tibble with these values.
}
\description{
Custom summary method for flexCountReg models
}
\details{
This summary method accounts for bootstrapped or robust standard errors (when
used).
}
\note{
Optional parameter `confint_level`: A numeric value between 0 and 1
  indicating the confidence level for confidence intervals. Default is 0.95.

Optional parameter `digits`: Number of digits (decimal places) to round
  to. Default is 3.
}
\examples{
\donttest{
# NB2 Model
data("washington_roads")
washington_roads$AADT10kplus <- ifelse(washington_roads$AADT > 10000, 1, 0)
nb2 <- countreg(Total_crashes ~ lnaadt + lnlength + speed50 + AADT10kplus,
                data = washington_roads, family = "NB2",
                dis_param_formula_1 = ~ speed50, method='BFGS')
summary(nb2)
}

}
