% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/99_growth_curves.R
\name{fn_qpl}
\alias{fn_qpl}
\title{Quadratic–plateau–linear function}
\usage{
fn_qpl(t, t1, t2, dt, b, k, beta)
}
\arguments{
\item{t}{A numeric vector of input values (e.g., time).}

\item{t1}{The onset time of the response. The function is 0 for all values
less than \code{t1}.}

\item{t2}{The time when the quadratic growth phase ends and the plateau
begins. Must be greater than \code{t1}.}

\item{dt}{Duration of the plateau. Defines \code{t3 = t2 + dt} and must be
non-negative.}

\item{b}{Linear coefficient of the quadratic growth phase.}

\item{k}{The plateau value (level maintained between \code{t2} and \code{t3}).}

\item{beta}{Slope of the final linear phase after \code{t3} (often negative).}
}
\value{
A numeric vector of the same length as \code{t}, representing the
  function values.
}
\description{
A piecewise function that models an initial quadratic increase from zero up
to a plateau, maintains that plateau for a duration, and then changes
linearly after the plateau ends.
}
\details{
The quadratic phase is parameterized so that the curve reaches exactly
\code{k} at \code{t2}. Let \eqn{\Delta = t_2 - t_1}. The quadratic coefficient
\eqn{c} is computed internally as:
\if{html}{
\deqn{
c = \frac{k - b\Delta}{\Delta^2}.
}
}

\if{html}{
\deqn{
f(t; t_1, t_2, dt, b, k, \beta) =
\begin{cases}
0 & \text{if } t < t_1 \\
b(t - t_1) + c(t - t_1)^2 & \text{if } t_1 \le t \le t_2 \\
k & \text{if } t_2 < t \le t_3 \\
k + \beta (t - t_3) & \text{if } t > t_3
\end{cases}
}
}

where \eqn{t_3 = t_2 + dt}.

The function is continuous at \code{t1}, \code{t2}, and \code{t3}. It is not
differentiable at \code{t3} unless \code{beta = 0}.
}
\examples{
library(flexFitR)
plot_fn(
  fn = "fn_qpl",
  params = c(t1 = 30, t2 = 60, dt = 20, b = 0.01, k = 0.9, beta = -0.01),
  interval = c(0, 100),
  n_points = 2000,
  auc_label_size = 3
)
}
