% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_plot.R
\name{plot}
\alias{plot}
\title{Generic Plot Function}
\usage{
plot(object, ...)
}
\arguments{
\item{object}{The object to be plotted.}

\item{...}{Additional arguments passed to specific plot methods.}
}
\value{
Depends on the class of \code{object}. Typically, a plot or visualization is returned.
}
\description{
This is a generic \code{plot} function that dispatches to specific \code{plot} methods
based on the class of the object provided. It is used to create plots for objects
such as \code{fuzzy_lm}.
}
\examples{
# Example with fuzzy_lm:
set.seed(123)
x_crisp <- seq(4, 12, length.out = 20)
beta <- 1.5
intercept <- 2
y_crisp <- intercept + beta * x_crisp + rnorm(length(x_crisp), mean = 0, sd = 0.5)

# Fuzzify data
spread_x <- 0.5
spread_y <- 1.0
X_fuzzy <- fuzzify_crisp_matrix(matrix(x_crisp, ncol = 1), spread = spread_x)
Y_fuzzy <- fuzzify_crisp_vector(y_crisp, spread = spread_y)

# Fit fuzzy regression model
object <- fuzzy_lm(X_fuzzy, Y_fuzzy, p = 1)

# Plot
\donttest{
plot(object, X_fuzzy = X_fuzzy, Y_fuzzy = Y_fuzzy)
}
}
