% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fmesher_sizes_mesh2d}
\alias{fmesher_sizes_mesh2d}
\title{Compute areas and edge lengths}
\usage{
fmesher_sizes_mesh2d(mesh_loc, mesh_tv, options)
}
\arguments{
\item{mesh_loc}{numeric matrix; mesh vertex coordinates}

\item{mesh_tv}{3-column integer matrix with 0-based vertex indices for each triangle}

\item{options}{list of triangulation options (\code{sphere_tolerance})}
}
\value{
A list of \code{face}, \code{face_edge}, and \code{vertex}
}
\description{
Internal C++ method.

Compute triangle areas, edge lengths, and vertex-associated areas
}
\examples{
mesh <- fm_mesh_2d(
  boundary = fm_segm(rbind(c(0,0), c(1,0), c(1,1), c(0, 1)), is.bnd = TRUE)
)
sz <- fm_sizes(mesh)
summary(sz$face)
}
\seealso{
\code{\link[=fm_sizes]{fm_sizes()}}
}
\keyword{internal}
