% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmi_functions.R
\name{run_dti_example}
\alias{run_dti_example}
\title{DTI Example Data Wrapper}
\usage{
run_dti_example(n_perms = 499L)
}
\arguments{
\item{n_perms}{The number of permutations (default: 499L).
Passed to \code{run_fmi}.}
}
\value{
Invisibly returns the FMI results list.
}
\description{
A helper function to load and pre-process the DTI dataset
from the 'refund' package for use in examples.
}
\examples{
\donttest{
  # n_perms=9 is for a quick check. Use 499+ for real analysis.
  if (requireNamespace("refund", quietly = TRUE)) {
    dti_results <- run_dti_example(n_perms = 9)
  }
}
}
