% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_apply.R
\name{fit_noise}
\alias{fit_noise}
\title{Fit an AR/ARMA noise model (run-aware) and return a whitening plan}
\usage{
fit_noise(
  resid = NULL,
  Y = NULL,
  X = NULL,
  runs = NULL,
  censor = NULL,
  method = c("ar", "arma"),
  p = "auto",
  q = 0L,
  p_max = 6L,
  exact_first = c("ar1", "none"),
  pooling = c("global", "run", "parcel"),
  parcels = NULL,
  parcel_sets = NULL,
  multiscale = c("pacf_weighted", "acvf_pooled"),
  ms_mode = NULL,
  p_target = NULL,
  beta = 0.5,
  hr_iter = 0L,
  step1 = c("burg", "yw"),
  parallel = FALSE
)
}
\arguments{
\item{resid}{Numeric matrix (time x voxels) of residuals from an initial OLS fit.}

\item{Y}{Optional data matrix used to compute residuals when \code{resid} is omitted.}

\item{X}{Optional design matrix used with \code{Y} to compute residuals.}

\item{runs}{Optional integer vector of run identifiers.}

\item{censor}{Optional integer vector of 1-based timepoint indices to exclude from
AR parameter estimation, or a logical vector of length \code{nrow(resid)} where \code{TRUE}

indicates censored timepoints. Censored frames (e.g., motion-corrupted) are excluded
when computing autocorrelations. Each run's estimation uses only its own valid
(non-censored) segments.}

\item{method}{Either "ar" or "arma".}

\item{p}{AR order (integer or "auto" if method == "ar").}

\item{q}{MA order (integer).}

\item{p_max}{Maximum AR order when \code{p = "auto"}.}

\item{exact_first}{Apply exact AR(1) scaling at segment starts ("ar1" or "none").}

\item{pooling}{Combine parameters across runs or parcels ("global", "run", "parcel").}

\item{parcels}{Integer vector (length = ncol(resid)) giving fine parcel memberships when \code{pooling = "parcel"}.}

\item{parcel_sets}{Optional named list with entries \code{coarse}, \code{medium}, \code{fine} of equal length specifying nested parcel labels for multi-scale pooling.}

\item{multiscale}{Multi-scale pooling mode when \code{parcel_sets} is supplied ("pacf_weighted" or "acvf_pooled"), or \code{TRUE/FALSE} to toggle pooling.}

\item{ms_mode}{Explicit multiscale mode when \code{multiscale} is logical.}

\item{p_target}{Target AR order for multi-scale pooling (defaults to \code{p_max}).}

\item{beta}{Size exponent for multi-scale weights (default 0.5).}

\item{hr_iter}{Number of Hannan--Rissanen refinement iterations for ARMA.}

\item{step1}{Preliminary high-order AR fit method for HR ("burg" or "yw").}

\item{parallel}{Reserved for future parallel estimation (logical).}
}
\value{
An object of class \code{fmriAR_plan} used by \code{\link[=whiten_apply]{whiten_apply()}}.
}
\description{
Fit an AR/ARMA noise model (run-aware) and return a whitening plan
}
\examples{
# Generate example data with AR(1) structure
n_time <- 200
n_voxels <- 50
phi_true <- 0.5

# Simulate residuals with AR(1) structure
resid <- matrix(0, n_time, n_voxels)
for (v in 1:n_voxels) {
  e <- rnorm(n_time)
  resid[1, v] <- e[1]
  for (t in 2:n_time) {
    resid[t, v] <- phi_true * resid[t-1, v] + e[t]
  }
}

# Fit AR model
plan <- fit_noise(resid, method = "ar", p = 1)

# With multiple runs
runs <- rep(1:2, each = 100)
plan_runs <- fit_noise(resid, runs = runs, method = "ar", pooling = "run")
}
