#' NCCTG Lung Cancer Marker Data
#'
#' This dataset contains four columns: \code{id}, the identifier for health institutions (clusters); \code{marker}, the risk score; \code{time}, the observed follow-up time; and \code{status}, the event indicator for subjects in the NCCTG lung cancer marker dataset.
#'
#' @docType data
#' @usage data(LungCancer)
#' @keywords datasets
#'
#' @format {This is a data frame with 238 observations and the following 4 variables.
#'    \describe{
#'    \item{id  }{health institutions code}
#'
#'    \item{time }{time to death in days}
#'
#'
#'    \item{status }{censoring indicator; 1=censored, 2=dead}
#'
#'    \item{marker }{risk score derived from the observed data using frailty model}
#'    }
#'    }
#'
#' @details {
#'    \describe{
#'          The NCCTG lung cancer dataset was collected from 228 patients across 18 different healthcare institutions.
#'          The number of subjects per institution ranged from 2 to 36. For the final analysis, only 226 patients with
#'          complete records were included. The dataset contains survival times along with several important predictor
#'          variables, including: sex (coded as Male = 1, Female = 2), age (in years), ph.ecog (Eastern Cooperative
#'          Oncology Group performance status, assessed by a physician on a scale from 0 [asymptomatic] to 5 [dead]),
#'          and pat.karno (Karnofsky performance status, assessed by the patient).
#'
#'          The marker (risk score) was derived from three predictor variables: sex, age, and ph.ecog. To this end,
#'          a frailty model with gamma-distributed frailty was fitted. As in the previous example, the prognostic marker is defined as:
#' \deqn{\hat{\nu} \exp(\hat{\beta}_1 \cdot \text{sex} + \hat{\beta}_2 \cdot \text{age} + \hat{\beta}_3 \cdot \text{ph.ecog})}
#'
#' where \eqn{\hat{\nu}} is the estimated frailty term, and \eqn{\hat{\beta}_i}(for \code{i=}1,2,3) are
#' the estimated regression coefficients from the frailty model.}
#' }
#'
#' @references Beyene, K. M., and Chen, D. G. (2024). Time-dependent receiver operating characteristic curve estimator for correlated right-censored time-to-event data. \emph{Statistical Methods in Medical Research}, 33(1), 162-181.
"LungCancer"


#' Kidney Marker Data
#'
#' This dataset contains four columns: \code{id}, patient code; \code{marker}, the risk score; \code{time}, the observed follow-up time; and \code{status}, the event indicator for subjects in the kidney marker dataset.
#'
#' @docType data
#' @usage data(kidney)
#' @keywords datasets
#'
#' @format {This is a data frame with 76 observations and the following 4 variables.
#'    \describe{
#'    \item{id  }{patient code}
#'
#'    \item{time }{time to recurrence of infection}
#'
#'    \item{status }{censoring indicator; 0=censored, 1=recurrence}
#'
#'    \item{marker }{risk score derived from observed data using frailty model}
#'    }
#'   }
#'
#' @details {
#'    \describe{
#' This dataset pertains to the recurrence of infection in patients with kidney disease who use portable dialysis equipment.
#' Recurrent infection is the primary complication in these patients, typically occurring at the catheter insertion site.
#' When an infection occurs, the catheter is removed and reinserted after successful treatment. In some cases, the catheter
#' is removed for reasons unrelated to infection; these observations are treated as censored. A total of 38 patients were
#' followed to assess the time to recurrence of infection. Each patient contributes exactly two observations.
#'
#' The dataset includes the following covariates: \code{sex} (1 = Male, 2 = Female), \code{age}, and \code{disease}
#' (Disease type; a factor with four levels: \code{"GN"}, \code{"AN"}, \code{"PKD"}, and \code{"Other"}). The marker is derived using a gamma frailty model as follows:
#' \deqn{
#'   \hat{\nu} \exp(\hat{\beta}_1 \, \mathrm{sex} + \hat{\beta}_2 \, \mathrm{age} + \hat{\beta}_3 \, \mathrm{GN} + \hat{\beta}_4 \, \mathrm{AN} + \hat{\beta}_5 \, \mathrm{PKD})
#' }
#'  where \eqn{\hat{\nu}} is the estimated frailty term, and \eqn{\hat{\beta}_i}(for \code{i=}1,2,3) are
#'  the estimated regression coefficients from the frailty model.}
#'}
#' @references Beyene, K. M., and Chen, D. G. (2024). Time-dependent receiver operating characteristic curve estimator for correlated right-censored time-to-event data. \emph{Statistical Methods in Medical Research}, 33(1), 162-181.
"kidney"
