% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.frailtyCmprsk.R
\name{plot.frailtyCmprsk}
\alias{plot.frailtyCmprsk}
\title{Plot Method for a Weibull competing risks model with optional shared frailty between transitions.}
\usage{
\method{plot}{frailtyCmprsk}(x, type.plot="Baseline hazard", events, conf.bands=TRUE, 
pos.legend="topright", cex.legend=0.7, lwd=c(1,1,1), color=2, median=TRUE, 
Xlab = "Time", Ylab = "Baseline hazard function",...)
}
\arguments{
\item{x}{A Weibull competing risks model, i.e. an \code{frailtyCmprsk} class object
(output from calling \code{frailtyCmprsk} function).}

\item{type.plot}{a character string specifying the type of curve. Possible
value are "Baseline hazard", or "Baseline survival". The default is "Baseline hazard".
Only the first letters are required, e.g "Haz", "Su".}

\item{events}{Integer vector specifying which competing events to display in the plots. 
Use 1 for the first event, 2 for the second, and so on. If not specified, plots for all events are shown.}

\item{conf.bands}{Logical value. Determines whether confidence bands will be
plotted.  The default is TRUE.}

\item{pos.legend}{The location of the legend can be specified by setting
this argument to a single keyword from the list '"bottomright"', '"bottom"',
'"bottomleft"', '"left"', '"topleft"', '"top"', '"topright"', '"right"' and
'"center"'. The default is '"topright"'}

\item{cex.legend}{character expansion factor *relative* to current
'par("cex")'. Default is 0.5}

\item{lwd}{A vector of length 3 of positive values to specify the line width of the plots and their
confidence bands. If no confidence bands are plotted, the last two elements of the vector are ignored.
Default is (1,1,1).}

\item{color}{color of the curve (integer)}

\item{median}{Logical value. Determines whether median survival time will be plotted. Default is TRUE.}

\item{Xlab}{Label of x-axis. Default is '"Time"'}

\item{Ylab}{Label of y-axis. Default is '"Baseline hazard function"'}

\item{...}{other unused arguments}
}
\value{
Print a plot of a Weibull competing risks model with optional shared
 frailty between transitions.
}
\description{
Plots estimated baseline survival and hazard functions from an object of
class 'frailtyCmprsk'. Confidence bands are allowed.
}
\details{
Plot Method for a Weibull competing risks model with optional shared frailty between transitions.
}
\examples{
\donttest{

    ###--- Simple Weibull competing risks model ---###

    data(CPRSKbmtcrr)

    ModCmprsk_NoCov_Factor <- frailtyCmprsk(
      formulas = list(
        Surv(observed_time, Status, type = "mstate") ~ D,
        ~ 1
      ),
      data = CPRSKbmtcrr,
      print.info = FALSE,
      maxit = 100
    )

    plot(ModCmprsk_NoCov_Factor)

    #-- No confidence bands
    plot(ModCmprsk_NoCov_Factor, conf.bands = FALSE)

}

}
\seealso{
\code{\link{frailtyCmprsk}}
}
\keyword{file}
