% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configure.R
\name{configure_data}
\alias{configure_data}
\title{Configure Data Source}
\usage{
configure_data(
  path = NULL,
  file = NULL,
  type = NULL,
  locked = FALSE,
  interactive = TRUE
)
}
\arguments{
\item{path}{Character. Dot-notation path for the data source (e.g., "source.private.survey")}

\item{file}{Character. File path to the data file}

\item{type}{Character. Data type: "csv", "tsv", "rds", "excel", "stata", "spss", "sas", or "auto"}

\item{locked}{Logical. If TRUE, file is read-only and errors on changes}

\item{interactive}{Logical. If TRUE, prompts for missing values. Default TRUE.}
}
\value{
Invisibly returns updated config
}
\description{
Interactively add a data source to settings.yml (or settings.yml for legacy projects). Data sources are defined
with dot-notation paths (e.g., "source.private.survey") and include metadata
like file path, type, and whether the data is locked.
}
\keyword{internal}
