% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{save_table}
\alias{save_table}
\title{Save a table to the outputs directory}
\usage{
save_table(data, name, format = "csv", public = FALSE, overwrite = TRUE, ...)
}
\arguments{
\item{data}{A data frame, tibble, or other tabular data}

\item{name}{The name for the output file (without extension)}

\item{format}{Output format: "csv" (default), "rds", "xlsx", or "parquet"}

\item{public}{If TRUE, saves to public outputs directory (for project_sensitive type)}

\item{overwrite}{If TRUE, overwrites existing files (default: TRUE)}

\item{...}{Additional arguments passed to the underlying write function}
}
\value{
The path to the saved file (invisibly)
}
\description{
Saves a data frame or tibble to the configured tables directory.
The directory is created lazily on first use.
}
\examples{
\donttest{
if (FALSE) {
# Save a simple table
save_table(my_results, "regression_results")

# Save as Excel
save_table(my_results, "regression_results", format = "xlsx")

# Save to public directory (for sensitive projects)
save_table(summary_stats, "summary", public = TRUE)
}
}

}
