% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo.R
\name{geo_object_type}
\alias{geo_object_type}
\title{Determine the geometry type of an \code{sf} object}
\usage{
geo_object_type(x)
}
\arguments{
\item{x}{An \code{sf} object whose geometry type should be determined.}
}
\value{
A single \code{character(1)} value representing the normalized geometry type.
Possible values are: \code{"POINT"}, \code{"LINE"}, \code{"POLYGON"}, or \code{"GEOMETRY"}.
}
\description{
This internal helper function identifies and normalizes the geometry type
of an \code{sf} object. It ensures that all geometries within the object share
a consistent type (e.g., \code{"POINT"}, \code{"LINESTRING"}, \code{"POLYGON"}).
If multiple geometry types are found, an error is raised.
}
\details{
The function retrieves the geometry type of the input using
\code{\link[sf:st_geometry_type]{sf::st_geometry_type()}} and standardizes it according to a simplified
classification:
\itemize{
\item \code{"POINT"} and \code{"MULTIPOINT"} = \code{"POINT"}
\item \code{"LINESTRING"} and \code{"MULTILINESTRING"} = \code{"LINE"}
\item \code{"POLYGON"} and \code{"MULTIPOLYGON"} = \code{"POLYGON"}
\item All other types = \code{"GEOMETRY"}
}

Mixed or inconsistent geometry collections are not supported.
}
\keyword{internal}
