% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo.R
\name{geo_spatial_filter}
\alias{geo_spatial_filter}
\title{Filter an sf layer by spatial relationship}
\usage{
geo_spatial_filter(layer, x, spatial_filter)
}
\arguments{
\item{layer}{An \code{sf} object to be filtered.}

\item{x}{An \code{sf} object used as reference for the spatial relationship.}

\item{spatial_filter}{Character. The spatial predicate to apply. Must be one of:
\code{"INTERSECTS"}, \code{"DISJOINT"}, \code{"CONTAINS"}, \code{"WITHIN"},
\code{"TOUCHES"}, \code{"BBOX"}, \code{"CROSSES"}, \code{"OVERLAPS"}, \code{"EQUALS"}.}
}
\value{
A subset of \code{layer} where features satisfy the specified spatial predicate
with respect to \code{x}.
}
\description{
This internal helper function filters features of an \code{sf} layer based on
a specified spatial relationship with another \code{sf} object.
}
\details{
\itemize{
\item Uses \code{\link[sf:geos_binary_pred]{sf::st_intersects()}}, \code{\link[sf:geos_binary_pred]{sf::st_disjoint()}}, \code{\link[sf:geos_binary_pred]{sf::st_contains()}}, etc.
depending on the value of \code{spatial_filter}.
\item \code{"BBOX"} is treated as a simple intersection with bounding boxes.
}
}
\keyword{internal}
