% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_heritage_layernames.R
\name{get_heritage_layernames}
\alias{get_heritage_layernames}
\title{Get heritage layer codes and labels}
\usage{
get_heritage_layernames(code = NULL)
}
\arguments{
\item{code}{Optional \code{character} vector of layer codes to filter.
If \code{NULL}, the full reference table is returned.}
}
\value{
A \code{data.frame} with two columns:
\describe{
\item{code}{Official heritage layer code (character).}
\item{label}{Descriptive label (character).}
}
}
\description{
This function provides a reference table mapping internal codes to
explore heritage layer available datasets from French Ministry
of Culture's "Atlas du Patrimoine".
Optionally, it can filter the table to return only selected codes.
}
\details{
The available codes and their meanings are:
\itemize{
\item \code{IMDN} — Domaines nationaux
\item \code{IMMH} — Immeubles classes ou inscrits
\item \code{IMUN} — Patrimoine Mondial UNESCO – Emprise surfacique des biens
\item \code{LACR} — Architecture Contemporaine Remarquable
\item \code{PADN} — Protection au titre des abords de domaines nationaux
\item \code{PAMH} — Protection au titre des abords de monuments historiques
\item \code{PAUN} — Patrimoine Mondial UNESCO – Zone tampon des biens
\item \code{SICI} — Sites classes ou inscrits
\item \code{SIPR} — Sites patrimoniaux remarquables
\item \code{ZPPA} — Zones de presomption de prescriptions archeologiques
}
}
\examples{
# Get the full table of heritage layer codes
get_heritage_layernames()

# Filter for specific codes
get_heritage_layernames(c("IMMH", "SICI"))

}
